/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.objects;

import javax.xml.transform.TransformerException;
import org.htmlunit.xpath.XPathVisitor;
import org.htmlunit.xpath.objects.XNodeSet;
import org.htmlunit.xpath.objects.XNumber;
import org.htmlunit.xpath.objects.XObject;
import org.htmlunit.xpath.xml.utils.WrappedRuntimeException;
import org.htmlunit.xpath.xml.utils.XMLCharacterRecognizer;

public class XString
extends XObject {
    public static final XString EMPTYSTRING = new XString("");

    public XString(String val) {
        super(val);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public String getTypeString() {
        return "#STRING";
    }

    public boolean hasString() {
        return true;
    }

    @Override
    public double num() {
        return this.toDouble();
    }

    public double toDouble() {
        XString s = this.trim();
        double result = Double.NaN;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '-' || c == '.' || c >= '0' && c <= '9') continue;
            return result;
        }
        try {
            result = Double.parseDouble(s.toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean bool() {
        return this.str().length() > 0;
    }

    @Override
    public XString xstr() {
        return this;
    }

    @Override
    public String str() {
        return null != this.m_obj ? (String)this.m_obj : "";
    }

    public int length() {
        return this.str().length();
    }

    public char charAt(int index) {
        return this.str().charAt(index);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.str().getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    @Override
    public boolean equals(XObject obj2) {
        int t = obj2.getType();
        try {
            if (4 == t) {
                return obj2.equals(this);
            }
            if (1 == t) {
                return obj2.bool() == this.bool();
            }
            if (2 == t) {
                return obj2.num() == this.num();
            }
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
        return this.xstr().equals(obj2.xstr());
    }

    public boolean equals(String obj2) {
        return this.str().equals(obj2);
    }

    public boolean equals(XString obj2) {
        if (obj2 != null) {
            if (!obj2.hasString()) {
                return obj2.equals(this.str());
            }
            return this.str().equals(obj2.toString());
        }
        return false;
    }

    public boolean equals(Object obj2) {
        if (null == obj2) {
            return false;
        }
        if (obj2 instanceof XNodeSet) {
            return obj2.equals(this);
        }
        if (obj2 instanceof XNumber) {
            return obj2.equals(this);
        }
        return this.str().equals(obj2.toString());
    }

    public boolean startsWith(XString prefix, int toffset) {
        int to = toffset;
        int tlim = this.length();
        int po = 0;
        int pc = prefix.length();
        if (toffset < 0 || toffset > tlim - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (this.charAt(to) != prefix.charAt(po)) {
                return false;
            }
            ++to;
            ++po;
        }
        return true;
    }

    public boolean startsWith(XString prefix) {
        return this.startsWith(prefix, 0);
    }

    public int indexOf(XString str) {
        return this.str().indexOf(str.toString());
    }

    public XString substring(int beginIndex) {
        return new XString(this.str().substring(beginIndex));
    }

    public XString substring(int beginIndex, int endIndex) {
        return new XString(this.str().substring(beginIndex, endIndex));
    }

    public XString trim() {
        return new XString(this.str().trim());
    }

    private static boolean isSpace(char ch) {
        return XMLCharacterRecognizer.isWhiteSpace(ch);
    }

    public XString fixWhiteSpace(boolean trimHead, boolean trimTail, boolean doublePunctuationSpaces) {
        int s;
        int len = this.length();
        char[] buf = new char[len];
        this.getChars(0, len, buf, 0);
        boolean edit = false;
        for (s = 0; s < len && !XString.isSpace(buf[s]); ++s) {
        }
        int d = s;
        boolean pres = false;
        while (s < len) {
            char c = buf[s];
            if (XString.isSpace(c)) {
                if (!pres) {
                    if (' ' != c) {
                        edit = true;
                    }
                    buf[d++] = 32;
                    if (doublePunctuationSpaces && s != 0) {
                        char prevChar = buf[s - 1];
                        if (prevChar != '.' && prevChar != '!' && prevChar != '?') {
                            pres = true;
                        }
                    } else {
                        pres = true;
                    }
                } else {
                    edit = true;
                    pres = true;
                }
            } else {
                buf[d++] = c;
                pres = false;
            }
            ++s;
        }
        if (trimTail && 1 <= d && ' ' == buf[d - 1]) {
            edit = true;
            --d;
        }
        int start = 0;
        if (trimHead && 0 < d && ' ' == buf[0]) {
            edit = true;
            ++start;
        }
        return edit ? new XString(new String(buf, start, d - start)) : this;
    }

    @Override
    public void callVisitors(XPathVisitor visitor) {
        visitor.visitStringLiteral();
    }
}

