/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.xerces.util;

import java.util.ArrayList;
import org.htmlunit.cyberneko.xerces.xni.QName;
import org.htmlunit.cyberneko.xerces.xni.XMLAttributes;

public class XMLAttributesImpl
implements XMLAttributes {
    private ArrayList<Attribute> fAttributes = new ArrayList();

    @Override
    public int addAttribute(QName name, String type, String value) {
        Attribute attribute = new Attribute();
        attribute.name.setValues(name);
        attribute.type = type;
        attribute.value = value;
        attribute.specified = false;
        this.fAttributes.add(attribute);
        return this.fAttributes.size() - 1;
    }

    @Override
    public void removeAllAttributes() {
        this.fAttributes.clear();
    }

    @Override
    public void removeAttributeAt(int attrIndex) {
        this.fAttributes.remove(attrIndex);
    }

    @Override
    public void setName(int attrIndex, QName attrName) {
        this.fAttributes.get(attrIndex).name.setValues(attrName);
    }

    @Override
    public void getName(int attrIndex, QName attrName) {
        attrName.setValues(this.fAttributes.get(attrIndex).name);
    }

    @Override
    public void setType(int attrIndex, String attrType) {
        this.fAttributes.get(attrIndex).type = attrType;
    }

    @Override
    public void setValue(int attrIndex, String attrValue) {
        Attribute attribute = this.fAttributes.get(attrIndex);
        attribute.value = attrValue;
    }

    @Override
    public void setSpecified(int attrIndex, boolean specified) {
        this.fAttributes.get(attrIndex).specified = specified;
    }

    @Override
    public boolean isSpecified(int attrIndex) {
        return this.fAttributes.get(attrIndex).specified;
    }

    @Override
    public int getLength() {
        return this.fAttributes.size();
    }

    @Override
    public String getType(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return this.getReportableType(this.fAttributes.get(index).type);
    }

    @Override
    public String getType(String qname) {
        int index = this.getIndex(qname);
        return index != -1 ? this.getReportableType(this.fAttributes.get(index).type) : null;
    }

    @Override
    public String getValue(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return this.fAttributes.get(index).value;
    }

    @Override
    public String getValue(String qname) {
        int index = this.getIndex(qname);
        return index != -1 ? this.fAttributes.get(index).value : null;
    }

    public String getName(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return ((Attribute)this.fAttributes.get((int)index)).name.rawname;
    }

    @Override
    public int getIndex(String qName) {
        for (int i = 0; i < this.getLength(); ++i) {
            Attribute attribute = this.fAttributes.get(i);
            if (((Attribute)attribute).name.rawname == null || !((Attribute)attribute).name.rawname.equals(qName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String uri, String localPart) {
        for (int i = 0; i < this.getLength(); ++i) {
            Attribute attribute = this.fAttributes.get(i);
            if (((Attribute)attribute).name.localpart == null || !((Attribute)attribute).name.localpart.equals(localPart) || uri != ((Attribute)attribute).name.uri && (uri == null || ((Attribute)attribute).name.uri == null || !((Attribute)attribute).name.uri.equals(uri))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getLocalName(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return ((Attribute)this.fAttributes.get((int)index)).name.localpart;
    }

    @Override
    public String getQName(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        String rawname = ((Attribute)this.fAttributes.get((int)index)).name.rawname;
        return rawname != null ? rawname : "";
    }

    @Override
    public String getType(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index != -1 ? this.getReportableType(this.fAttributes.get(index).type) : null;
    }

    @Override
    public String getURI(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return ((Attribute)this.fAttributes.get((int)index)).name.uri;
    }

    @Override
    public String getValue(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index != -1 ? this.getValue(index) : null;
    }

    public void addAttributeNS(QName name, String type, String value) {
        Attribute attribute = new Attribute();
        attribute.name.setValues(name);
        attribute.type = type;
        attribute.value = value;
        attribute.specified = false;
        this.fAttributes.add(attribute);
    }

    private String getReportableType(String type) {
        if (type.charAt(0) == '(') {
            return "NMTOKEN";
        }
        return type;
    }

    private static final class Attribute {
        private final QName name = new QName();
        private String type;
        private String value;
        private boolean specified;

        private Attribute() {
        }
    }
}

