/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.xerces.util;

import java.util.ArrayList;
import org.htmlunit.cyberneko.xerces.xni.QName;
import org.htmlunit.cyberneko.xerces.xni.XMLAttributes;

public class XMLAttributesImpl
implements XMLAttributes {
    private final ArrayList<Attribute> attributes_ = new ArrayList();

    @Override
    public int addAttribute(QName name, String type, String value) {
        this.addAttribute(name, type, value, false);
        return this.attributes_.size() - 1;
    }

    public void addAttribute(QName name, String type, String value, boolean specified) {
        Attribute attribute = new Attribute();
        attribute.name_.setValues(name);
        attribute.type_ = type;
        attribute.value_ = value;
        attribute.specified_ = specified;
        this.attributes_.add(attribute);
    }

    public void addAttribute(QName name, String type, String value, String nonNormalizedValue, boolean specified) {
        AttributeExt attribute = new AttributeExt();
        attribute.name_.setValues(name);
        attribute.type_ = type;
        attribute.value_ = value;
        attribute.nonNormalizedValue_ = nonNormalizedValue;
        attribute.specified_ = specified;
        this.attributes_.add(attribute);
    }

    @Override
    public void removeAllAttributes() {
        this.attributes_.clear();
    }

    @Override
    public void removeAttributeAt(int attrIndex) {
        this.attributes_.remove(attrIndex);
    }

    @Override
    public void setName(int attrIndex, QName attrName) {
        this.attributes_.get((int)attrIndex).name_.setValues(attrName);
    }

    @Override
    public void getName(int attrIndex, QName attrName) {
        attrName.setValues(this.attributes_.get((int)attrIndex).name_);
    }

    @Override
    public void setValue(int attrIndex, String attrValue) {
        Attribute attribute = this.attributes_.get(attrIndex);
        attribute.value_ = attrValue;
    }

    @Override
    public void setSpecified(int attrIndex, boolean specified) {
        this.attributes_.get((int)attrIndex).specified_ = specified;
    }

    @Override
    public boolean isSpecified(int attrIndex) {
        return this.attributes_.get((int)attrIndex).specified_;
    }

    @Override
    public int getLength() {
        return this.attributes_.size();
    }

    @Override
    public String getType(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return XMLAttributesImpl.getReportableType(this.attributes_.get((int)index).type_);
    }

    @Override
    public String getType(String qname) {
        int index = this.getIndex(qname);
        return index != -1 ? XMLAttributesImpl.getReportableType(this.attributes_.get((int)index).type_) : null;
    }

    @Override
    public String getValue(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return this.attributes_.get((int)index).value_;
    }

    @Override
    public String getValue(String qname) {
        int index = this.getIndex(qname);
        return index != -1 ? this.attributes_.get((int)index).value_ : null;
    }

    public String getNameRawName(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return this.attributes_.get((int)index).name_.getRawname();
    }

    @Override
    public QName getName(int index) {
        return this.attributes_.get((int)index).name_;
    }

    @Override
    public int getIndex(String qName) {
        for (int i = 0; i < this.getLength(); ++i) {
            Attribute attribute = this.attributes_.get(i);
            if (attribute.name_.getRawname() == null || !attribute.name_.getRawname().equals(qName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String uri, String localPart) {
        for (int i = 0; i < this.getLength(); ++i) {
            Attribute attribute = this.attributes_.get(i);
            if (attribute.name_.getLocalpart() == null || !attribute.name_.getLocalpart().equals(localPart) || uri != attribute.name_.getUri() && (uri == null || attribute.name_.getUri() == null || !attribute.name_.getUri().equals(uri))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getLocalName(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return this.attributes_.get((int)index).name_.getLocalpart();
    }

    @Override
    public String getQName(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        String rawname = this.attributes_.get((int)index).name_.getRawname();
        return rawname != null ? rawname : "";
    }

    @Override
    public String getType(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index != -1 ? XMLAttributesImpl.getReportableType(this.attributes_.get((int)index).type_) : null;
    }

    @Override
    public String getURI(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return this.attributes_.get((int)index).name_.getUri();
    }

    @Override
    public String getValue(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index != -1 ? this.getValue(index) : null;
    }

    @Override
    public String getNonNormalizedValue(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return this.attributes_.get(index).getNonNormalizedValue();
    }

    @Override
    public boolean isDeclared(int index) {
        return false;
    }

    @Override
    public boolean isDeclared(String qName) {
        return false;
    }

    @Override
    public boolean isDeclared(String uri, String localName) {
        return false;
    }

    @Override
    public boolean isSpecified(String qName) {
        int index = this.getIndex(qName);
        if (index == -1) {
            throw new IllegalArgumentException(qName);
        }
        return this.isSpecified(index);
    }

    @Override
    public boolean isSpecified(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        if (index == -1) {
            throw new IllegalArgumentException(localName);
        }
        return this.isSpecified(index);
    }

    public ArrayList<Attribute> getAttributes() {
        return this.attributes_;
    }

    private static String getReportableType(String type) {
        if (type.charAt(0) == '(') {
            return "NMTOKEN";
        }
        return type;
    }

    static class AttributeExt
    extends Attribute {
        String nonNormalizedValue_;

        AttributeExt() {
        }

        @Override
        String getNonNormalizedValue() {
            return this.nonNormalizedValue_;
        }
    }

    public static class Attribute {
        final QName name_ = new QName();
        String type_;
        String value_;
        boolean specified_;

        public QName getQName() {
            return this.name_;
        }

        public String getValue() {
            return this.value_;
        }

        String getNonNormalizedValue() {
            return this.value_;
        }
    }
}

