/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.xerces.dom;

import java.util.ArrayList;
import org.htmlunit.cyberneko.xerces.dom.ElementImpl;
import org.htmlunit.cyberneko.xerces.dom.NodeImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeepNodeListImpl
implements NodeList {
    protected final NodeImpl rootNode_;
    protected final String tagName_;
    private int changes_ = 0;
    private ArrayList<Node> nodes_;
    private String nsName_;
    private boolean enableNS_ = false;

    public DeepNodeListImpl(NodeImpl rootNode, String tagName) {
        this.rootNode_ = rootNode;
        this.tagName_ = tagName;
        this.nodes_ = new ArrayList();
    }

    public DeepNodeListImpl(NodeImpl rootNode, String nsName, String tagName) {
        this(rootNode, tagName);
        this.nsName_ = nsName != null && nsName.length() != 0 ? nsName : null;
        this.enableNS_ = true;
    }

    @Override
    public int getLength() {
        this.item(Integer.MAX_VALUE);
        return this.nodes_.size();
    }

    @Override
    public Node item(int index) {
        int currentSize;
        if (this.rootNode_.changes() != this.changes_) {
            this.nodes_ = new ArrayList();
            this.changes_ = this.rootNode_.changes();
        }
        if (index < (currentSize = this.nodes_.size())) {
            return this.nodes_.get(index);
        }
        Node thisNode = currentSize == 0 ? this.rootNode_ : this.nodes_.get(currentSize - 1);
        while (thisNode != null && index >= this.nodes_.size()) {
            if ((thisNode = this.nextMatchingElementAfter(thisNode)) == null) continue;
            this.nodes_.add(thisNode);
        }
        return thisNode;
    }

    protected Node nextMatchingElementAfter(Node current) {
        while (current != null) {
            ElementImpl el;
            Node next;
            if (current.hasChildNodes()) {
                current = current.getFirstChild();
            } else if (current != this.rootNode_ && null != (next = current.getNextSibling())) {
                current = next;
            } else {
                next = null;
                while (current != this.rootNode_ && (next = current.getNextSibling()) == null) {
                    current = current.getParentNode();
                }
                current = next;
            }
            if (current == this.rootNode_ || current == null || current.getNodeType() != 1) continue;
            if (!this.enableNS_) {
                if (!"*".equals(this.tagName_) && !((ElementImpl)current).getTagName().equals(this.tagName_)) continue;
                return current;
            }
            if ("*".equals(this.tagName_)) {
                if ("*".equals(this.nsName_)) {
                    return current;
                }
                el = (ElementImpl)current;
                if ((this.nsName_ != null || el.getNamespaceURI() != null) && (this.nsName_ == null || !this.nsName_.equals(el.getNamespaceURI()))) continue;
                return current;
            }
            el = (ElementImpl)current;
            if (el.getLocalName() == null || !el.getLocalName().equals(this.tagName_)) continue;
            if ("*".equals(this.nsName_)) {
                return current;
            }
            if ((this.nsName_ != null || el.getNamespaceURI() != null) && (this.nsName_ == null || !this.nsName_.equals(el.getNamespaceURI()))) continue;
            return current;
        }
        return null;
    }
}

