/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy.provider;

import java.io.IOException;
import java.util.ArrayList;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smackx.privacy.packet.Privacy;
import org.jivesoftware.smackx.privacy.packet.PrivacyItem;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PrivacyProvider
extends IQProvider<Privacy> {
    public Privacy parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
        Privacy privacy = new Privacy();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("active")) {
                    String activeName = parser.getAttributeValue("", "name");
                    if (activeName == null) {
                        privacy.setDeclineActiveList(true);
                        continue;
                    }
                    privacy.setActiveName(activeName);
                    continue;
                }
                if (parser.getName().equals("default")) {
                    String defaultName = parser.getAttributeValue("", "name");
                    if (defaultName == null) {
                        privacy.setDeclineDefaultList(true);
                        continue;
                    }
                    privacy.setDefaultName(defaultName);
                    continue;
                }
                if (!parser.getName().equals("list")) continue;
                PrivacyProvider.parseList(parser, privacy);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("query")) continue;
            done = true;
        }
        return privacy;
    }

    private static void parseList(XmlPullParser parser, Privacy privacy) throws XmlPullParserException, IOException, SmackException {
        boolean done = false;
        String listName = parser.getAttributeValue("", "name");
        ArrayList<PrivacyItem> items = new ArrayList<PrivacyItem>();
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("item")) continue;
                items.add(PrivacyProvider.parseItem(parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("list")) continue;
            done = true;
        }
        privacy.setPrivacyList(listName, items);
    }

    private static PrivacyItem parseItem(XmlPullParser parser) throws XmlPullParserException, IOException, SmackException {
        PrivacyItem item;
        boolean allow;
        String actionValue = parser.getAttributeValue("", "action");
        long order = ParserUtils.getLongAttribute((XmlPullParser)parser, (String)"order");
        String type = parser.getAttributeValue("", "type");
        switch (actionValue) {
            case "allow": {
                allow = true;
                break;
            }
            case "deny": {
                allow = false;
                break;
            }
            default: {
                throw new SmackException("Unknown action value '" + actionValue + "'");
            }
        }
        if (type != null) {
            String value = parser.getAttributeValue("", "value");
            item = new PrivacyItem(PrivacyItem.Type.valueOf(type), value, allow, order);
        } else {
            item = new PrivacyItem(allow, order);
        }
        PrivacyProvider.parseItemChildElements(parser, item);
        return item;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseItemChildElements(XmlPullParser parser, PrivacyItem privacyItem) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "iq": {
                            privacyItem.setFilterIQ(true);
                            break block0;
                        }
                        case "message": {
                            privacyItem.setFilterMessage(true);
                            break block0;
                        }
                        case "presence-in": {
                            privacyItem.setFilterPresenceIn(true);
                            break block0;
                        }
                        case "presence-out": {
                            privacyItem.setFilterPresenceOut(true);
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }
}

