/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.gson.adapter;

import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.immutables.gson.stream.JsonParserReader;

public final class ExpectedSubtypesAdapter<T>
extends TypeAdapter<T> {
    private final TypeToken<T> type;
    private final Gson gson;
    private final List<TypeAdapter<? extends T>> adapters;
    private final TypeToken<? extends T>[] subtypes;

    @SafeVarargs
    public static <T> ExpectedSubtypesAdapter<T> create(Gson gson, TypeToken<T> type, TypeToken<? extends T> ... subtypes) {
        return new ExpectedSubtypesAdapter<T>(gson, type, subtypes);
    }

    private ExpectedSubtypesAdapter(Gson gson, TypeToken<T> type, TypeToken<? extends T>[] subtypes) {
        if (subtypes.length < 1) {
            throw new IllegalArgumentException("At least one subtype should be specified");
        }
        if (gson == null) {
            throw new NullPointerException("supplied Gson is null");
        }
        if (type == null) {
            throw new NullPointerException("supplied type Gson is null");
        }
        this.gson = gson;
        this.type = type;
        this.subtypes = (TypeToken[])subtypes.clone();
        this.adapters = this.lookupAdapters();
    }

    private List<TypeAdapter<? extends T>> lookupAdapters() {
        ArrayList<TypeAdapter<T>> adapters = new ArrayList<TypeAdapter<T>>(this.subtypes.length);
        for (TypeToken<? extends T> subtype : this.subtypes) {
            adapters.add(this.gson.getAdapter(subtype));
        }
        return adapters;
    }

    public TypeToken<T> getType() {
        return this.type;
    }

    public void write(JsonWriter out, T value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        for (int i = 0; i < this.subtypes.length; ++i) {
            TypeToken<? extends T> subtype = this.subtypes[i];
            if (!subtype.getRawType().isInstance(value)) continue;
            TypeAdapter<? extends T> typeAdapter = this.adapters.get(i);
            typeAdapter.write(out, value);
            return;
        }
        this.gson.toJson(value, value.getClass(), out);
    }

    public T read(JsonReader in) throws IOException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>(this.subtypes.length);
        ReaderSupplier readerSupplier = this.readForSupplier(in);
        for (TypeAdapter<? extends T> typeAdapter : this.adapters) {
            try {
                return (T)typeAdapter.read(readerSupplier.create());
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        JsonParseException failure = new JsonParseException(String.format("Cannot parse %s with following subtypes: %s", this.type, Arrays.toString(this.subtypes)));
        for (Exception exception : exceptions) {
            failure.addSuppressed((Throwable)exception);
        }
        throw failure;
    }

    private ReaderSupplier readForSupplier(JsonReader in) throws IOException {
        if (in instanceof Callable) {
            return new JsonParserReaderSupplier(in);
        }
        return new JsonReaderSupplier(in);
    }

    private static class JsonParserReaderSupplier
    implements ReaderSupplier {
        private final TokenBuffer buffer;

        JsonParserReaderSupplier(JsonReader in) throws IOException {
            this.buffer = ((JsonParserReader)in).nextTokenBuffer();
        }

        @Override
        public JsonReader create() {
            return new JsonParserReader(this.buffer.asParser());
        }
    }

    private static class JsonReaderSupplier
    implements ReaderSupplier {
        private final JsonElement element;

        JsonReaderSupplier(JsonReader in) throws IOException {
            this.element = (JsonElement)TypeAdapters.JSON_ELEMENT.read(in);
        }

        @Override
        public JsonReader create() {
            return new JsonTreeReader(this.element);
        }
    }

    private static interface ReaderSupplier {
        public JsonReader create();
    }
}

