/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.gson.adapter;

import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.immutables.gson.stream.JsonParserReader;

public final class ExpectedSubtypesAdapter<T>
extends TypeAdapter<T> {
    private final TypeToken<T> type;
    private final Gson gson;
    private final List<TypeAdapter<? extends T>> adapters;
    private final TypeToken<? extends T>[] subtypes;

    @SafeVarargs
    public static <T> ExpectedSubtypesAdapter<T> create(Gson gson, TypeToken<T> type, TypeToken<? extends T> ... subtypes) {
        return new ExpectedSubtypesAdapter<T>(gson, type, subtypes);
    }

    @SafeVarargs
    public static <T> ExpectedSubtypesAdapter<T> create(Gson gson, Class<T> type, TypeToken<? extends T> ... subtypes) {
        return ExpectedSubtypesAdapter.create(gson, TypeToken.get(type), subtypes);
    }

    private ExpectedSubtypesAdapter(Gson gson, TypeToken<T> type, TypeToken<? extends T>[] subtypes) {
        if (subtypes.length < 1) {
            throw new IllegalArgumentException("At least one subtype should be specified");
        }
        if (gson == null) {
            throw new NullPointerException("supplied Gson is null");
        }
        if (type == null) {
            throw new NullPointerException("supplied type Gson is null");
        }
        this.gson = gson;
        this.type = type;
        this.subtypes = (TypeToken[])subtypes.clone();
        this.adapters = this.lookupAdapters();
    }

    private List<TypeAdapter<? extends T>> lookupAdapters() {
        ArrayList<TypeAdapter<T>> adapters = new ArrayList<TypeAdapter<T>>(this.subtypes.length);
        for (TypeToken<? extends T> subtype : this.subtypes) {
            adapters.add(this.gson.getAdapter(subtype));
        }
        return adapters;
    }

    public TypeToken<T> getType() {
        return this.type;
    }

    public void write(JsonWriter out, T value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        for (int i = 0; i < this.subtypes.length; ++i) {
            TypeToken<? extends T> subtype = this.subtypes[i];
            if (!subtype.getRawType().isInstance(value)) continue;
            TypeAdapter<? extends T> typeAdapter = this.adapters.get(i);
            typeAdapter.write(out, value);
            return;
        }
        this.gson.toJson(value, value.getClass(), out);
    }

    public T read(JsonReader in) throws IOException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>(this.subtypes.length);
        ReadAttempt attempt = this.readInAttempt(in);
        for (TypeAdapter<? extends T> typeAdapter : this.adapters) {
            try {
                return (T)attempt.read(typeAdapter);
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        JsonParseException failure = new JsonParseException(String.format("Cannot parse %s with following subtypes: %s", this.type, Arrays.toString(this.subtypes)));
        for (Exception exception : exceptions) {
            failure.addSuppressed((Throwable)exception);
        }
        throw failure;
    }

    private ReadAttempt readInAttempt(JsonReader in) throws IOException {
        if (in instanceof Callable && in instanceof JsonParserReader) {
            return this.newJacksonAttempt((JsonParserReader)in);
        }
        return this.newGsonAttempt(in);
    }

    private ReadAttempt newGsonAttempt(JsonReader in) throws IOException {
        final JsonElement element = (JsonElement)this.gson.getAdapter(JsonElement.class).read(in);
        return new ReadAttempt(){

            @Override
            public Object read(TypeAdapter<?> typeAdapter) throws Exception {
                return typeAdapter.fromJsonTree(element);
            }
        };
    }

    private ReadAttempt newJacksonAttempt(JsonParserReader in) throws IOException {
        final TokenBuffer buffer = in.nextTokenBuffer();
        return new ReadAttempt(){

            @Override
            public Object read(TypeAdapter<?> typeAdapter) throws Exception {
                try (JsonParserReader reader = new JsonParserReader(buffer.asParser());){
                    Object object = typeAdapter.read((JsonReader)reader);
                    return object;
                }
            }
        };
    }

    private static interface ReadAttempt {
        public Object read(TypeAdapter<?> var1) throws Exception;
    }
}

