/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.concurrent;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.immutables.mongo.concurrent.FluentFuture;

public final class FluentFutures {
    private FluentFutures() {
    }

    @Deprecated
    public static <V> FluentFuture<V> from(FluentFuture<V> future) {
        return future;
    }

    public static <V> FluentFuture<V> from(ListenableFuture<V> future) {
        if (future instanceof FluentFuture) {
            return (FluentFuture)future;
        }
        return new WrapingFluentFuture(future, MoreExecutors.directExecutor());
    }

    private static class LazyTransformedFluentFuture<V, F>
    extends WrapingFluentFuture<V> {
        private final Function<? super F, ? extends V> function;
        private final ListenableFuture<F> fromFuture;

        LazyTransformedFluentFuture(ListenableFuture<F> fromFuture, Function<? super F, ? extends V> function, Executor executor) {
            super(fromFuture, executor);
            this.fromFuture = fromFuture;
            this.function = function;
        }

        public V get() throws InterruptedException, ExecutionException {
            return (V)this.function.apply(this.fromFuture.get());
        }

        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (V)this.function.apply(this.fromFuture.get(timeout, unit));
        }
    }

    private static class WrapingFluentFuture<V>
    extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V>
    implements FluentFuture<V> {
        private final Executor executor;

        private WrapingFluentFuture(ListenableFuture<V> future, Executor executor) {
            super(future);
            this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        }

        @Override
        public V getUnchecked() {
            return (V)Futures.getUnchecked((Future)((Object)this));
        }

        @Override
        public FluentFuture<V> addCallback(FutureCallback<V> callback) {
            Futures.addCallback((ListenableFuture)this, callback, (Executor)this.executor);
            return this;
        }

        @Override
        public FluentFuture<V> catching(Function<Throwable, V> fallback) {
            return FluentFutures.from(Futures.catching((ListenableFuture)this, Throwable.class, fallback, (Executor)this.executor));
        }

        @Override
        public FluentFuture<V> withFallbackValue(final V value) {
            return this.catching(new Function<Throwable, V>(){

                public V apply(Throwable t) {
                    return value;
                }
            });
        }

        @Override
        public <T> FluentFuture<T> transform(Function<? super V, ? extends T> function) {
            return FluentFutures.from(Futures.transform((ListenableFuture)this, function, (Executor)this.executor));
        }

        @Override
        public <T> FluentFuture<T> asyncTransform(AsyncFunction<? super V, ? extends T> function) {
            return FluentFutures.from(Futures.transformAsync((ListenableFuture)this, function, (Executor)this.executor));
        }

        @Override
        public FluentFuture<V> withExecutor(Executor executor) {
            if (this.executor == executor) {
                return this;
            }
            return new WrapingFluentFuture<V>(this.delegate(), executor);
        }

        @Override
        public <T> FluentFuture<T> lazyTransform(Function<? super V, ? extends T> function) {
            return new LazyTransformedFluentFuture<T, V>(this, function, this.executor);
        }
    }
}

