/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.types;

import java.util.Arrays;
import javax.annotation.concurrent.Immutable;
import org.bson.types.ObjectId;

@Immutable
public final class Id {
    private final byte[] data;

    private Id(byte[] data) {
        this.data = data;
    }

    public static Id fromString(String string) {
        return Id.from(new ObjectId(string));
    }

    public static Id from(byte[] data) {
        return new Id((byte[])data.clone());
    }

    private static Id from(ObjectId objectId) {
        return new Id(objectId.toByteArray());
    }

    public byte[] value() {
        return (byte[])this.data.clone();
    }

    public static Id generate() {
        return Id.from(ObjectId.get());
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Id) {
            Id id = (Id)other;
            return Arrays.equals(this.data, id.data);
        }
        return false;
    }

    public String toString() {
        return new ObjectId(this.data).toString();
    }
}

