package borg.immutables.fixture.packoutput.impl;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.fixture.packoutput.Packs;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;
import org.immutables.value.Generated;

/**
 * A {@code PacksRepository} provides type-safe access for storing and retrieving documents
 * from the MongoDB collection {@code "packs"}.
 */
@Generated(from = "org.immutables.fixture.packoutput.Packs", generator = "Repositories")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@ThreadSafe
public class PacksRepository extends Repositories.Repository<Packs> {
  private static final String DOCUMENT_COLLECTION_NAME = "packs";

  private final Serialization serialization;
  private final Criteria anyCriteria;

  /**
   * Constructs a {@link Packs} repository using {@link RepositorySetup configuration}.
   * @param configuration The repository configuration
   */
  public PacksRepository(RepositorySetup configuration) {
    super(configuration, DOCUMENT_COLLECTION_NAME, Packs.class);
    this.serialization = new Serialization(codecRegistry(), fieldNamingStrategy());
    this.anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());
  }

  /**
   * Inserts a single document into the collection.
   * @param document The packs to insert
   * @return A future representing the number of inserted documents (1) if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(Packs document) {
    return super.doInsert(ImmutableList.of(document));
  }

  /**
   * Insert documents into the collection.
   * @param documents The documents to insert
   * @return A future representing the number of inserted documents if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(Iterable<? extends Packs> documents) {
    return super.doInsert(ImmutableList.copyOf(documents));
  }

  /**
   * Finds all documents. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch all} or other operations.
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder findAll() {
    return find(criteria());
  }

  /**
   * Find documents by the criteria expressed as a JSON string. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch} or {@link Finder#fetchFirst() fetch} operations.
   * @param jsonCriteria A JSON string for native criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(String jsonCriteria) {
    return new Finder(this, Support.jsonQuery(jsonCriteria));
  }

  /**
   * Find a document by the given {@link PacksRepository#criteria() criteria}. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch}  operations.
   * You can also use {@link Finder#andModifyFirst() modify} or {@link Finder#deleteFirst() delete}
   * operations to update / delete the document(s).
   * @param criteria The search criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(Criteria criteria) {
    return new Finder(this, criteria.constraint);
  }

  /**
   * The finder object used to proceed with find operations via the
   * {@link Finder#fetchAll()}, {@link Finder#fetchFirst()}, {@link Finder#andModifyFirst()}, or {@link Finder#deleteFirst()} methods.
   * Configure exclusion and sort ordering for results using the family of {@code exclude*()} and {@code orderBy*()} attribute-specific methods.
   * @see PacksRepository#find(Criteria)
   */
  @Generated(from = "org.immutables.fixture.packoutput.Packs", generator = "Repositories")
  @NotThreadSafe
  public static final class Finder extends Repositories.FinderWithDelete<Packs, Finder> {
    private final Serialization serialization;

    private Finder(PacksRepository repository, Constraints.ConstraintHost criteria) {
      super(repository);
      this.criteria = criteria;
      this.serialization = repository.serialization;
    }

    /**
     * Order by {@link Packs#perk() perk} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Packs#perk() perk} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByPerk() {
      ordering = ordering.equal(serialization.perkName, false, 1);
      return this;
    }

    /**
     * Order by {@link Packs#perk() perk} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Packs#perk() perk} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByPerkDesceding() {
      ordering = ordering.equal(serialization.perkName, false, -1);
      return this;
    }

    /**
     * Turn a find operation into an atomic {@link DBCollection#findAndModify(DBObject, DBObject, DBObject, boolean, DBObject, boolean, boolean) findAndModify}
     * operation. Use the family of {@code set*()}, {@code unset*()}, {@code add*()}, {@code remove*()}, {@code put*()}m and {@code init*()}
     * (and other attribute-specific) methods to describe the modification.
     * @return A modifier object to complete the {@code findAndModify} operation
     */
    @CheckReturnValue
    public Modifier andModifyFirst() {
      return new Modifier((PacksRepository) repository, criteria, ordering, exclusion);
    }

    /**
     * Used to replace in-place existing version of the document
     */
    @CheckReturnValue
    public Replacer andReplaceFirst(Packs document) {
      return new Replacer((PacksRepository) repository, document, criteria, ordering);
    }
  }

  /**
   * Update the set of {@code "packs"} documents.
   * @param criteria The search criteria for update
   * @return An updater object that will be used to complete the update.
   */
  @CheckReturnValue
  public Updater update(Criteria criteria) {
    return new Updater(this, criteria);
  }

  /**
   * {@link #update(Criteria) Given} the criteria updater describes how to perform
   * update operations on sets of documents.
   */
  @Generated(from = "org.immutables.fixture.packoutput.Packs", generator = "Repositories")
  @NotThreadSafe
  public static final class Updater extends Repositories.Updater<Packs> {
    private final Serialization serialization;

    private Updater(PacksRepository repository, Criteria criteria) {
      super(repository);
      this.criteria = criteria.constraint;
      this.serialization = repository.serialization;
    }

    /**
     * Specify a new value for the {@code perk} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code perk} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setPerk(Packs.Perk value) {
      setFields = setFields.equal(serialization.perkName, false, Support.writable(serialization.perkEncoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code perk} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code perk} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initPerk(Packs.Perk value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.perkName, false, Support.writable(serialization.perkEncoder, value));
      return this;
    }

  }

  @Generated(from = "org.immutables.fixture.packoutput.Packs", generator = "Repositories")
  @NotThreadSafe
  public static final class Modifier extends Repositories.Modifier<Packs, Modifier> {
    private final Serialization serialization;

    private Modifier(
        PacksRepository repository,
        Constraints.ConstraintHost criteria,
        Constraints.Constraint ordering,
        Constraints.Constraint exclusion) {
      super(repository);
      this.serialization = repository.serialization;
      this.criteria = criteria;
      this.ordering = ordering;
      this.exclusion = exclusion;
    }

    /**
     * Specify a new value for the {@code perk} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code perk} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setPerk(Packs.Perk value) {
      setFields = setFields.equal(serialization.perkName, false, Support.writable(serialization.perkEncoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code perk} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code perk} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initPerk(Packs.Perk value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.perkName, false, Support.writable(serialization.perkEncoder, value));
      return this;
    }

  }

  @Generated(from = "org.immutables.fixture.packoutput.Packs", generator = "Repositories")
  @NotThreadSafe
  public static final class Replacer extends Repositories.Replacer<Packs, Replacer> {
    protected Replacer(PacksRepository repository, Packs document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
      super(repository, document, criteria, ordering);
    }
  }

  /**
   * {@link DBCollection#createIndex(DBObject, DBObject) Ensure an index} on collection packs by one or
   * more attributes using the family of {@code with*()} attribute-specific methods.
   * While indexes will usually be maintained by special administration scripts, for simple cases it is convenient
   * to ensure an index on application startup.
   * @see Indexer#named(String)
   * @see Indexer#unique()
   * @return An indexer object to be completed with the {@link Indexer#ensure()} operation.
   */
  @CheckReturnValue
  public Indexer index() {
    return new Indexer(this);
  }

  /**
   * An indexer used to create an index on the {@code "packs"} collection if it does not exist by one or more attributes.
   * @see DBCollection#createIndex(DBObject, DBObject)
   */
  @Generated(from = "org.immutables.fixture.packoutput.Packs", generator = "Repositories")
  @NotThreadSafe
  public static final class Indexer extends Repositories.Indexer<Packs, Indexer> {
    private final Serialization serialization;

    private Indexer(PacksRepository repository) {
      super(repository);
      this.serialization = repository.serialization;
    }

    /**
     * Specify that the next attribute to index will be {@link Packs#perk() perk}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withPerk() {
      fields = fields.equal(serialization.perkName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Packs#perk() perk}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withPerkDesceding() {
      fields = fields.equal(serialization.perkName, false, -1);
      return this;
    }
  }

  /**
   * Search criteria.
   * Returns an initial object to create criteria by invoking methods that describe attribute specific constraints.
   * @return An empty immutable criteria
   */
  public Criteria criteria() {
    return anyCriteria;
  }

  @Beta
  Bson toBson(Criteria criteria) {
    return Support.convertToBson(criteria.constraint);
  }

  /**
   * {@code PacksRepository.Criteria} is a Packs document search query.
   * Call methods on the criteria to add constraints for search queries.
   */
  @Generated(from = "org.immutables.fixture.packoutput.Packs", generator = "Repositories")
  @Immutable
  @SuppressWarnings("unchecked")
  public static final class Criteria extends Repositories.Criteria {
    private final Constraints.Constraint constraint;
    private final Serialization serialization;

    Criteria(Serialization serialization, Constraints.Constraint constraint) {
      this.constraint = constraint;
      this.serialization = serialization;
    }

    public Criteria perk(Packs.Perk value) {
      return new Criteria(serialization, constraint.equal(serialization.perkName, false, Support.writable(serialization.perkEncoder, value)));
    }

    public Criteria perkNot(Packs.Perk value) {
      return new Criteria(serialization, constraint.equal(serialization.perkName, true, Support.writable(serialization.perkEncoder, value)));
    }

    public Criteria perkIn(Iterable<Packs.Perk> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Packs.Perk value : values) {
        wrappedValues.add(Support.writable(serialization.perkEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.perkName, false, wrappedValues));
    }

    public Criteria perkIn(Packs.Perk first, Packs.Perk second, Packs.Perk... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.perkEncoder, first));
      values.add(Support.writable(serialization.perkEncoder, second));
      for (Packs.Perk value : rest) {
        values.add(Support.writable(serialization.perkEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.perkName, false, values));
    }

    public Criteria perkNotIn(Iterable<Packs.Perk> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Packs.Perk value : values) {
        wrappedValues.add(Support.writable(serialization.perkEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.perkName, true, wrappedValues));
    }

    public Criteria perkNotIn(Packs.Perk first, Packs.Perk second, Packs.Perk... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.perkEncoder, first));
      values.add(Support.writable(serialization.perkEncoder, second));
      for (Packs.Perk value : rest) {
        values.add(Support.writable(serialization.perkEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.perkName, true, values));
    }

    @Override
    public Criteria or() {
      return new Criteria(serialization, constraint.disjunction());
    }

    public Criteria with(Criteria criteria) {
      return new Criteria(serialization, criteria.constraint.accept(constraint));
    }

    @Override
    public String toString() {
      return "PacksRepository.criteria(" + Support.stringify(constraint) + ")";
    }
  }

  @Generated(from = "org.immutables.fixture.packoutput.Packs", generator = "Repositories")
  private static class Serialization {
    final Encoder<Packs.Perk> perkEncoder;
    final CodecRegistry registry;
    final String perkName;

    Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {
      this.registry = registry;
      this.perkEncoder = this.registry.get(Packs.Perk.class);
      this.perkName = translateName(fieldNamingStrategy, "perk");
    }

    @Generated(from = "org.immutables.fixture.packoutput.Packs", generator = "Repositories")
    static final class PacksNamingFields {
      public Packs.Perk perk;
    }

    private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {
      try {
        return fieldNamingStrategy.translateName(
            PacksNamingFields.class.getField(fieldName));
      } catch (NoSuchFieldException noSuchField) {
        throw new AssertionError(noSuchField);
      }
    }
  }
}
