package nonimmutables.bravo;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import nonimmutables.alpha.Charlie;
import nonimmutables.alpha.ImmutableDelta;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Echo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEcho.builder()}.
 */
@Generated(from = "Echo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableEcho implements Echo {
  private final ImmutableDelta delta;
  private final nonimmutables.bravo.ImmutableDelta buelta;

  private ImmutableEcho(ImmutableDelta delta, nonimmutables.bravo.ImmutableDelta buelta) {
    this.delta = delta;
    this.buelta = buelta;
  }

  /**
   * @return The value of the {@code delta} attribute
   */
  @Override
  public ImmutableDelta getDelta() {
    return delta;
  }

  /**
   * @return The value of the {@code buelta} attribute
   */
  @Override
  public nonimmutables.bravo.ImmutableDelta getBuelta() {
    return buelta;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Echo#getDelta() delta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delta
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEcho withDelta(ImmutableDelta value) {
    if (this.delta == value) return this;
    ImmutableDelta newValue = Objects.requireNonNull(value, "delta");
    return new ImmutableEcho(newValue, this.buelta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Echo#getBuelta() buelta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for buelta
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEcho withBuelta(nonimmutables.bravo.ImmutableDelta value) {
    if (this.buelta == value) return this;
    nonimmutables.bravo.ImmutableDelta newValue = Objects.requireNonNull(value, "buelta");
    return new ImmutableEcho(this.delta, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEcho} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEcho
        && equalTo(0, (ImmutableEcho) another);
  }

  private boolean equalTo(int synthetic, ImmutableEcho another) {
    return delta.equals(another.delta)
        && buelta.equals(another.buelta);
  }

  /**
   * Computes a hash code from attributes: {@code delta}, {@code buelta}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + delta.hashCode();
    h += (h << 5) + buelta.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Echo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Echo")
        .omitNullValues()
        .add("delta", delta)
        .add("buelta", buelta)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Echo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Echo instance
   */
  public static ImmutableEcho copyOf(Echo instance) {
    if (instance instanceof ImmutableEcho) {
      return (ImmutableEcho) instance;
    }
    return ImmutableEcho.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEcho ImmutableEcho}.
   * <pre>
   * ImmutableEcho.builder()
   *    .delta(nonimmutables.alpha.ImmutableDelta) // required {@link Echo#getDelta() delta}
   *    .buelta(nonimmutables.bravo.ImmutableDelta) // required {@link Echo#getBuelta() buelta}
   *    .build();
   * </pre>
   * @return A new ImmutableEcho builder
   */
  public static ImmutableEcho.Builder builder() {
    return new ImmutableEcho.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEcho ImmutableEcho}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Echo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DELTA = 0x1L;
    private static final long INIT_BIT_BUELTA = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ImmutableDelta delta;
    private @Nullable nonimmutables.bravo.ImmutableDelta buelta;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code nonimmutables.bravo.Echo} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Echo instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code nonimmutables.alpha.Charlie} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Charlie instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Echo) {
        Echo instance = (Echo) object;
        if ((bits & 0x1L) == 0) {
          delta(instance.getDelta());
          bits |= 0x1L;
        }
        buelta(instance.getBuelta());
      }
      if (object instanceof Charlie) {
        Charlie instance = (Charlie) object;
        if ((bits & 0x1L) == 0) {
          delta(instance.getDelta());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Echo#getDelta() delta} attribute.
     * @param delta The value for delta 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder delta(ImmutableDelta delta) {
      this.delta = Objects.requireNonNull(delta, "delta");
      initBits &= ~INIT_BIT_DELTA;
      return this;
    }

    /**
     * Initializes the value for the {@link Echo#getBuelta() buelta} attribute.
     * @param buelta The value for buelta 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder buelta(nonimmutables.bravo.ImmutableDelta buelta) {
      this.buelta = Objects.requireNonNull(buelta, "buelta");
      initBits &= ~INIT_BIT_BUELTA;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEcho ImmutableEcho}.
     * @return An immutable instance of Echo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEcho build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEcho(delta, buelta);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELTA) != 0) attributes.add("delta");
      if ((initBits & INIT_BIT_BUELTA) != 0) attributes.add("buelta");
      return "Cannot build Echo, some of required attributes are not set " + attributes;
    }
  }
}
