package org.immutables.fixture;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.mongo.types.Id;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code SillyEntitySecond}.
 * @see ImmutableSillyEntitySecond
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture", generator = "Gsons")
public final class GsonAdaptersSillyEntitySecond implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (SillyEntitySecondTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new SillyEntitySecondTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersSillyEntitySecond(SillyEntitySecond)";
  }

  @org.immutables.value.Generated(from = "SillyEntitySecond", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class SillyEntitySecondTypeAdapter extends TypeAdapter<SillyEntitySecond> {
    public final Id idTypeSample = null;
    private final TypeAdapter<Id> idTypeAdapter;

    SillyEntitySecondTypeAdapter(Gson gson) {
      this.idTypeAdapter = gson.getAdapter( Id.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return SillyEntitySecond.class == type.getRawType()
          || ImmutableSillyEntitySecond.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, SillyEntitySecond value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeSillyEntitySecond(out, value);
      }
    }

    @Override
    public SillyEntitySecond read(JsonReader in) throws IOException {
      return readSillyEntitySecond(in);
    }

    private void writeSillyEntitySecond(JsonWriter out, SillyEntitySecond instance)
        throws IOException {
      out.beginObject();
      out.name("_id");
      idTypeAdapter.write(out, instance.id());
      out.endObject();
    }

    private  SillyEntitySecond readSillyEntitySecond(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableSillyEntitySecond.Builder builder = ImmutableSillyEntitySecond.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableSillyEntitySecond.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case '_':
        if ("_id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableSillyEntitySecond.Builder builder)
        throws IOException {
      Id value = idTypeAdapter.read(in);
      builder.id(value);
    }
  }
}
