package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UnrelatedGenericMethods.Abb}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAbb.builder()}.
 */
@Generated(from = "UnrelatedGenericMethods.Abb", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableAbb implements UnrelatedGenericMethods.Abb {
  private final int x;

  private ImmutableAbb(ImmutableAbb.Builder builder) {
    this.x = builder.xIsSet()
        ? builder.x
        : UnrelatedGenericMethods.Abb.super.x();
  }

  private ImmutableAbb(int x) {
    this.x = x;
  }

  /**
   * @return The value of the {@code x} attribute
   */
  @Override
  public int x() {
    return x;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UnrelatedGenericMethods.Abb#x() x} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for x
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAbb withX(int value) {
    if (this.x == value) return this;
    return new ImmutableAbb(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAbb} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAbb
        && equalTo(0, (ImmutableAbb) another);
  }

  private boolean equalTo(int synthetic, ImmutableAbb another) {
    return x == another.x;
  }

  /**
   * Computes a hash code from attributes: {@code x}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + x;
    return h;
  }

  /**
   * Prints the immutable value {@code Abb} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Abb")
        .omitNullValues()
        .add("x", x)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link UnrelatedGenericMethods.Abb} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Abb instance
   */
  public static ImmutableAbb copyOf(UnrelatedGenericMethods.Abb instance) {
    if (instance instanceof ImmutableAbb) {
      return (ImmutableAbb) instance;
    }
    return ImmutableAbb.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAbb ImmutableAbb}.
   * <pre>
   * ImmutableAbb.builder()
   *    .x(int) // optional {@link UnrelatedGenericMethods.Abb#x() x}
   *    .build();
   * </pre>
   * @return A new ImmutableAbb builder
   */
  public static ImmutableAbb.Builder builder() {
    return new ImmutableAbb.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAbb ImmutableAbb}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UnrelatedGenericMethods.Abb", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_X = 0x1L;
    private long optBits;

    private int x;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Abb} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UnrelatedGenericMethods.Abb instance) {
      Objects.requireNonNull(instance, "instance");
      x(instance.x());
      return this;
    }

    /**
     * Initializes the value for the {@link UnrelatedGenericMethods.Abb#x() x} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link UnrelatedGenericMethods.Abb#x() x}.</em>
     * @param x The value for x 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder x(int x) {
      this.x = x;
      optBits |= OPT_BIT_X;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAbb ImmutableAbb}.
     * @return An immutable instance of Abb
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAbb build() {
      return new ImmutableAbb(this);
    }

    private boolean xIsSet() {
      return (optBits & OPT_BIT_X) != 0;
    }
  }
}
