package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AllMandatoryParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAllMandatoryParams.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAllMandatoryParams.of()}.
 */
@Generated(from = "AllMandatoryParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAllMandatoryParams implements AllMandatoryParams {
  private final int a;
  private final boolean b;
  private final String s;
  private final Object o;
  private final String c;

  private ImmutableAllMandatoryParams(int a, boolean b, String s, Object o) {
    this.a = a;
    this.b = b;
    this.s = s;
    this.o = o;
    this.c = AllMandatoryParams.super.c();
  }

  private ImmutableAllMandatoryParams(ImmutableAllMandatoryParams.Builder builder) {
    this.a = builder.a;
    this.b = builder.b;
    this.s = builder.s;
    this.o = builder.o;
    this.c = builder.cIsSet()
        ? builder.c
        : AllMandatoryParams.super.c();
  }

  private ImmutableAllMandatoryParams(int a, boolean b, String s, Object o, String c) {
    this.a = a;
    this.b = b;
    this.s = s;
    this.o = o;
    this.c = c;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public boolean b() {
    return b;
  }

  /**
   * @return The value of the {@code s} attribute
   */
  @Override
  public String s() {
    return s;
  }

  /**
   * @return The value of the {@code o} attribute
   */
  @Override
  public Object o() {
    return o;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public String c() {
    return c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllMandatoryParams#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllMandatoryParams withA(int value) {
    if (this.a == value) return this;
    return new ImmutableAllMandatoryParams(value, this.b, this.s, this.o, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllMandatoryParams#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllMandatoryParams withB(boolean value) {
    if (this.b == value) return this;
    return new ImmutableAllMandatoryParams(this.a, value, this.s, this.o, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllMandatoryParams#s() s} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for s (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllMandatoryParams withS(String value) {
    if (Objects.equals(this.s, value)) return this;
    return new ImmutableAllMandatoryParams(this.a, this.b, value, this.o, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllMandatoryParams#o() o} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for o (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllMandatoryParams withO(Object value) {
    if (this.o == value) return this;
    return new ImmutableAllMandatoryParams(this.a, this.b, this.s, value, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllMandatoryParams#c() c} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllMandatoryParams withC(String value) {
    String newValue = value;
    if (this.c.equals(newValue)) return this;
    return new ImmutableAllMandatoryParams(this.a, this.b, this.s, this.o, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAllMandatoryParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAllMandatoryParams
        && equalTo(0, (ImmutableAllMandatoryParams) another);
  }

  private boolean equalTo(int synthetic, ImmutableAllMandatoryParams another) {
    return a == another.a
        && b == another.b
        && Objects.equals(s, another.s)
        && Objects.equals(o, another.o)
        && c.equals(another.c);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code s}, {@code o}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + Booleans.hashCode(b);
    h += (h << 5) + Objects.hashCode(s);
    h += (h << 5) + Objects.hashCode(o);
    h += (h << 5) + c.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AllMandatoryParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AllMandatoryParams")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .add("s", s)
        .add("o", o)
        .add("c", c)
        .toString();
  }

  /**
   * Construct a new immutable {@code AllMandatoryParams} instance.
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @param s The value for the {@code s} attribute
   * @param o The value for the {@code o} attribute
   * @return An immutable AllMandatoryParams instance
   */
  public static ImmutableAllMandatoryParams of(int a, boolean b, String s, Object o) {
    return new ImmutableAllMandatoryParams(a, b, s, o);
  }

  /**
   * Creates an immutable copy of a {@link AllMandatoryParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AllMandatoryParams instance
   */
  public static ImmutableAllMandatoryParams copyOf(AllMandatoryParams instance) {
    if (instance instanceof ImmutableAllMandatoryParams) {
      return (ImmutableAllMandatoryParams) instance;
    }
    return ImmutableAllMandatoryParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAllMandatoryParams ImmutableAllMandatoryParams}.
   * <pre>
   * ImmutableAllMandatoryParams.builder()
   *    .a(int) // required {@link AllMandatoryParams#a() a}
   *    .b(boolean) // required {@link AllMandatoryParams#b() b}
   *    .s(String | null) // nullable {@link AllMandatoryParams#s() s}
   *    .o(Object | null) // nullable {@link AllMandatoryParams#o() o}
   *    .c(String) // optional {@link AllMandatoryParams#c() c}
   *    .build();
   * </pre>
   * @return A new ImmutableAllMandatoryParams builder
   */
  public static ImmutableAllMandatoryParams.Builder builder() {
    return new ImmutableAllMandatoryParams.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAllMandatoryParams ImmutableAllMandatoryParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AllMandatoryParams", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private static final long INIT_BIT_S = 0x4L;
    private static final long INIT_BIT_O = 0x8L;
    private static final long OPT_BIT_C = 0x1L;
    private long initBits = 0xfL;
    private long optBits;

    private int a;
    private boolean b;
    private @Nullable String s;
    private @Nullable Object o;
    private @Nullable String c;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AllMandatoryParams} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AllMandatoryParams instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      String sValue = instance.s();
      if (sValue != null) {
        s(sValue);
      }
      Object oValue = instance.o();
      if (oValue != null) {
        o(oValue);
      }
      c(instance.c());
      return this;
    }

    /**
     * Initializes the value for the {@link AllMandatoryParams#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link AllMandatoryParams#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(boolean b) {
      this.b = b;
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link AllMandatoryParams#s() s} attribute.
     * @param s The value for s (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder s(String s) {
      this.s = s;
      initBits &= ~INIT_BIT_S;
      return this;
    }

    /**
     * Initializes the value for the {@link AllMandatoryParams#o() o} attribute.
     * @param o The value for o (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder o(Object o) {
      this.o = o;
      initBits &= ~INIT_BIT_O;
      return this;
    }

    /**
     * Initializes the value for the {@link AllMandatoryParams#c() c} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AllMandatoryParams#c() c}.</em>
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(String c) {
      this.c = c;
      optBits |= OPT_BIT_C;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAllMandatoryParams ImmutableAllMandatoryParams}.
     * @return An immutable instance of AllMandatoryParams
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAllMandatoryParams build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAllMandatoryParams(this);
    }

    private boolean cIsSet() {
      return (optBits & OPT_BIT_C) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_S) != 0) attributes.add("s");
      if ((initBits & INIT_BIT_O) != 0) attributes.add("o");
      return "Cannot build AllMandatoryParams, some of required attributes are not set " + attributes;
    }
  }
}
