package org.immutables.fixture;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AuxDefaultOnForcedSingleton}.
 * <p>
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableAuxDefaultOnForcedSingleton.of()}.
 */
@Generated(from = "AuxDefaultOnForcedSingleton", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAuxDefaultOnForcedSingleton
    extends AuxDefaultOnForcedSingleton {
  private final int aux;

  private ImmutableAuxDefaultOnForcedSingleton() {
    this.aux = super.aux();
  }

  private ImmutableAuxDefaultOnForcedSingleton(int aux) {
    this.aux = aux;
  }

  /**
   * @return The value of the {@code aux} attribute
   */
  @Override
  public int aux() {
    return aux;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuxDefaultOnForcedSingleton#aux() aux} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for aux
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAuxDefaultOnForcedSingleton withAux(int value) {
    if (this.aux == value) return this;
    return validate(new ImmutableAuxDefaultOnForcedSingleton(value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAuxDefaultOnForcedSingleton} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAuxDefaultOnForcedSingleton
        && equalTo(0, (ImmutableAuxDefaultOnForcedSingleton) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableAuxDefaultOnForcedSingleton another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 556428701;
  }

  /**
   * Prints the immutable value {@code AuxDefaultOnForcedSingleton}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AuxDefaultOnForcedSingleton{}";
  }

  private static final ImmutableAuxDefaultOnForcedSingleton INSTANCE = validate(new ImmutableAuxDefaultOnForcedSingleton());

  /**
   * Returns the default immutable singleton value of {@code AuxDefaultOnForcedSingleton}
   * @return An immutable instance of AuxDefaultOnForcedSingleton
   */
  public static ImmutableAuxDefaultOnForcedSingleton of() {
    return INSTANCE;
  }

  private static ImmutableAuxDefaultOnForcedSingleton validate(ImmutableAuxDefaultOnForcedSingleton instance) {
    return instance;
  }
}
