package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CancelParam}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCancelParam.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableCancelParam.of()}.
 */
@Generated(from = "CancelParam", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCancelParam implements CancelParam {
  private final int a;
  private final ImmutableList<Integer> aux;

  private ImmutableCancelParam(int a) {
    this.a = a;
    this.aux = ImmutableList.of();
  }

  private ImmutableCancelParam(int a, ImmutableList<Integer> aux) {
    this.a = a;
    this.aux = aux;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code aux} attribute
   */
  @Override
  public ImmutableList<Integer> aux() {
    return aux;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CancelParam#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCancelParam withA(int value) {
    if (this.a == value) return this;
    return new ImmutableCancelParam(value, this.aux);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CancelParam#aux() aux}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCancelParam withAux(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableCancelParam(this.a, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CancelParam#aux() aux}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of aux elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCancelParam withAux(Iterable<Integer> elements) {
    if (this.aux == elements) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCancelParam(this.a, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCancelParam} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCancelParam
        && equalTo(0, (ImmutableCancelParam) another);
  }

  private boolean equalTo(int synthetic, ImmutableCancelParam another) {
    return a == another.a
        && aux.equals(another.aux);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code aux}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + aux.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CancelParam} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CancelParam")
        .omitNullValues()
        .add("a", a)
        .add("aux", aux)
        .toString();
  }

  /**
   * Construct a new immutable {@code CancelParam} instance.
   * @param a The value for the {@code a} attribute
   * @return An immutable CancelParam instance
   */
  public static ImmutableCancelParam of(int a) {
    return new ImmutableCancelParam(a);
  }

  /**
   * Creates an immutable copy of a {@link CancelParam} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CancelParam instance
   */
  public static ImmutableCancelParam copyOf(CancelParam instance) {
    if (instance instanceof ImmutableCancelParam) {
      return (ImmutableCancelParam) instance;
    }
    return ImmutableCancelParam.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCancelParam ImmutableCancelParam}.
   * <pre>
   * ImmutableCancelParam.builder()
   *    .a(int) // required {@link CancelParam#a() a}
   *    .addAux|addAllAux(int) // {@link CancelParam#aux() aux} elements
   *    .build();
   * </pre>
   * @return A new ImmutableCancelParam builder
   */
  public static ImmutableCancelParam.Builder builder() {
    return new ImmutableCancelParam.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCancelParam ImmutableCancelParam}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CancelParam", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private int a;
    private ImmutableList.Builder<Integer> aux = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.Param} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Param instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.CancelParam} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CancelParam instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Param) {
        Param instance = (Param) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
      }
      if (object instanceof CancelParam) {
        CancelParam instance = (CancelParam) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
        addAllAux(instance.aux());
      }
    }

    /**
     * Initializes the value for the {@link CancelParam#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Adds one element to {@link CancelParam#aux() aux} list.
     * @param element A aux element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAux(int element) {
      this.aux.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CancelParam#aux() aux} list.
     * @param elements An array of aux elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAux(int... elements) {
      this.aux.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CancelParam#aux() aux} list.
     * @param elements An iterable of aux elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder aux(Iterable<Integer> elements) {
      this.aux = ImmutableList.builder();
      return addAllAux(elements);
    }

    /**
     * Adds elements to {@link CancelParam#aux() aux} list.
     * @param elements An iterable of aux elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllAux(Iterable<Integer> elements) {
      this.aux.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCancelParam ImmutableCancelParam}.
     * @return An immutable instance of CancelParam
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCancelParam build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCancelParam(a, aux.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build CancelParam, some of required attributes are not set " + attributes;
    }
  }
}
