package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CopySuppressWarnings}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCopySuppressWarnings.builder()}.
 */
@Generated(from = "CopySuppressWarnings", generator = "Immutables")
@SuppressWarnings({"varargs", "all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCopySuppressWarnings implements CopySuppressWarnings {
  private final ImmutableSet<List<String>> elements;

  private ImmutableCopySuppressWarnings(ImmutableSet<List<String>> elements) {
    this.elements = elements;
  }

  /**
   * @return The value of the {@code elements} attribute
   */
  @Override
  public ImmutableSet<List<String>> elements() {
    return elements;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CopySuppressWarnings#elements() elements}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableCopySuppressWarnings withElements(List<String>... elements) {
    ImmutableSet<List<String>> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableCopySuppressWarnings(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CopySuppressWarnings#elements() elements}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of elements elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCopySuppressWarnings withElements(Iterable<? extends List<String>> elements) {
    if (this.elements == elements) return this;
    ImmutableSet<List<String>> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableCopySuppressWarnings(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCopySuppressWarnings} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCopySuppressWarnings
        && equalTo(0, (ImmutableCopySuppressWarnings) another);
  }

  private boolean equalTo(int synthetic, ImmutableCopySuppressWarnings another) {
    return elements.equals(another.elements);
  }

  /**
   * Computes a hash code from attributes: {@code elements}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + elements.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CopySuppressWarnings} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CopySuppressWarnings")
        .omitNullValues()
        .add("elements", elements)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CopySuppressWarnings} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CopySuppressWarnings instance
   */
  public static ImmutableCopySuppressWarnings copyOf(CopySuppressWarnings instance) {
    if (instance instanceof ImmutableCopySuppressWarnings) {
      return (ImmutableCopySuppressWarnings) instance;
    }
    return ImmutableCopySuppressWarnings.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCopySuppressWarnings ImmutableCopySuppressWarnings}.
   * <pre>
   * ImmutableCopySuppressWarnings.builder()
   *    .addElements|addAllElements(List&amp;lt;String&amp;gt;) // {@link CopySuppressWarnings#elements() elements} elements
   *    .build();
   * </pre>
   * @return A new ImmutableCopySuppressWarnings builder
   */
  public static ImmutableCopySuppressWarnings.Builder builder() {
    return new ImmutableCopySuppressWarnings.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCopySuppressWarnings ImmutableCopySuppressWarnings}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CopySuppressWarnings", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableSet.Builder<List<String>> elements = ImmutableSet.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CopySuppressWarnings} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CopySuppressWarnings instance) {
      Objects.requireNonNull(instance, "instance");
      addAllElements(instance.elements());
      return this;
    }

    /**
     * Adds one element to {@link CopySuppressWarnings#elements() elements} set.
     * @param element A elements element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addElements(List<String> element) {
      this.elements.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CopySuppressWarnings#elements() elements} set.
     * @param elements An array of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addElements(List<String>... elements) {
      this.elements.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CopySuppressWarnings#elements() elements} set.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder elements(Iterable<? extends List<String>> elements) {
      this.elements = ImmutableSet.builder();
      return addAllElements(elements);
    }

    /**
     * Adds elements to {@link CopySuppressWarnings#elements() elements} set.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllElements(Iterable<? extends List<String>> elements) {
      this.elements.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCopySuppressWarnings ImmutableCopySuppressWarnings}.
     * @return An immutable instance of CopySuppressWarnings
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCopySuppressWarnings build() {
      return new ImmutableCopySuppressWarnings(elements.build());
    }
  }
}
