package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DefaultAsDefault}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDefaultAsDefault.builder()}.
 */
@Generated(from = "DefaultAsDefault", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDefaultAsDefault implements DefaultAsDefault {
  private final int a;
  private final int b;

  private ImmutableDefaultAsDefault(ImmutableDefaultAsDefault.Builder builder) {
    if (builder.aIsSet()) {
      initShim.a(builder.a);
    }
    if (builder.bIsSet()) {
      initShim.b(builder.b);
    }
    this.a = initShim.a();
    this.b = initShim.b();
    this.initShim = null;
  }

  private ImmutableDefaultAsDefault(int a, int b) {
    this.a = a;
    this.b = b;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "DefaultAsDefault", generator = "Immutables")
  private final class InitShim {
    private byte aBuildStage = STAGE_UNINITIALIZED;
    private int a;

    int a() {
      if (aBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (aBuildStage == STAGE_UNINITIALIZED) {
        aBuildStage = STAGE_INITIALIZING;
        this.a = aInitialize();
        aBuildStage = STAGE_INITIALIZED;
      }
      return this.a;
    }

    void a(int a) {
      this.a = a;
      aBuildStage = STAGE_INITIALIZED;
    }

    private byte bBuildStage = STAGE_UNINITIALIZED;
    private int b;

    int b() {
      if (bBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (bBuildStage == STAGE_UNINITIALIZED) {
        bBuildStage = STAGE_INITIALIZING;
        this.b = bInitialize();
        bBuildStage = STAGE_INITIALIZED;
      }
      return this.b;
    }

    void b(int b) {
      this.b = b;
      bBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (aBuildStage == STAGE_INITIALIZING) attributes.add("a");
      if (bBuildStage == STAGE_INITIALIZING) attributes.add("b");
      return "Cannot build DefaultAsDefault, attribute initializers form cycle " + attributes;
    }
  }

  private int aInitialize() {
    return DefaultAsDefault.super.a();
  }

  private int bInitialize() {
    return DefaultAsDefault.super.b();
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.a()
        : this.a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public int b() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.b()
        : this.b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultAsDefault#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDefaultAsDefault withA(int value) {
    if (this.a == value) return this;
    return new ImmutableDefaultAsDefault(value, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultAsDefault#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDefaultAsDefault withB(int value) {
    if (this.b == value) return this;
    return new ImmutableDefaultAsDefault(this.a, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDefaultAsDefault} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDefaultAsDefault
        && equalTo(0, (ImmutableDefaultAsDefault) another);
  }

  private boolean equalTo(int synthetic, ImmutableDefaultAsDefault another) {
    return a == another.a
        && b == another.b;
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b;
    return h;
  }

  /**
   * Prints the immutable value {@code DefaultAsDefault} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DefaultAsDefault")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DefaultAsDefault} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DefaultAsDefault instance
   */
  public static ImmutableDefaultAsDefault copyOf(DefaultAsDefault instance) {
    if (instance instanceof ImmutableDefaultAsDefault) {
      return (ImmutableDefaultAsDefault) instance;
    }
    return ImmutableDefaultAsDefault.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDefaultAsDefault ImmutableDefaultAsDefault}.
   * <pre>
   * ImmutableDefaultAsDefault.builder()
   *    .a(int) // optional {@link DefaultAsDefault#a() a}
   *    .b(int) // optional {@link DefaultAsDefault#b() b}
   *    .build();
   * </pre>
   * @return A new ImmutableDefaultAsDefault builder
   */
  public static ImmutableDefaultAsDefault.Builder builder() {
    return new ImmutableDefaultAsDefault.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDefaultAsDefault ImmutableDefaultAsDefault}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultAsDefault", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_A = 0x1L;
    private static final long OPT_BIT_B = 0x2L;
    private long optBits;

    private int a;
    private int b;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DefaultAsDefault} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DefaultAsDefault instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultAsDefault#a() a} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DefaultAsDefault#a() a}.</em>
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      optBits |= OPT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultAsDefault#b() b} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DefaultAsDefault#b() b}.</em>
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(int b) {
      this.b = b;
      optBits |= OPT_BIT_B;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDefaultAsDefault ImmutableDefaultAsDefault}.
     * @return An immutable instance of DefaultAsDefault
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDefaultAsDefault build() {
      return new ImmutableDefaultAsDefault(this);
    }

    private boolean aIsSet() {
      return (optBits & OPT_BIT_A) != 0;
    }

    private boolean bIsSet() {
      return (optBits & OPT_BIT_B) != 0;
    }
  }
}
