package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DefaultDerivedInit}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDefaultDerivedInit.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDefaultDerivedInit.of()}.
 */
@Generated(from = "DefaultDerivedInit", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDefaultDerivedInit extends DefaultDerivedInit {
  private transient final String index;
  private final String uuid;
  private final String title;

  private ImmutableDefaultDerivedInit(String uuid, String title) {
    initShim.uuid(Objects.requireNonNull(uuid, "uuid"));
    this.title = Objects.requireNonNull(title, "title");
    this.index = initShim.index();
    this.uuid = initShim.uuid();
    this.initShim = null;
  }

  private ImmutableDefaultDerivedInit(ImmutableDefaultDerivedInit.Builder builder) {
    this.title = builder.title;
    if (builder.uuid != null) {
      initShim.uuid(builder.uuid);
    }
    this.index = initShim.index();
    this.uuid = initShim.uuid();
    this.initShim = null;
  }

  private ImmutableDefaultDerivedInit(ImmutableDefaultDerivedInit original, String uuid, String title) {
    initShim.uuid(uuid);
    this.title = title;
    this.index = initShim.index();
    this.uuid = initShim.uuid();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "DefaultDerivedInit", generator = "Immutables")
  private final class InitShim {
    private byte indexBuildStage = STAGE_UNINITIALIZED;
    private String index;

    String index() {
      if (indexBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (indexBuildStage == STAGE_UNINITIALIZED) {
        indexBuildStage = STAGE_INITIALIZING;
        this.index = Objects.requireNonNull(ImmutableDefaultDerivedInit.super.index(), "index");
        indexBuildStage = STAGE_INITIALIZED;
      }
      return this.index;
    }

    private byte uuidBuildStage = STAGE_UNINITIALIZED;
    private String uuid;

    String uuid() {
      if (uuidBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (uuidBuildStage == STAGE_UNINITIALIZED) {
        uuidBuildStage = STAGE_INITIALIZING;
        this.uuid = Objects.requireNonNull(ImmutableDefaultDerivedInit.super.uuid(), "uuid");
        uuidBuildStage = STAGE_INITIALIZED;
      }
      return this.uuid;
    }

    void uuid(String uuid) {
      this.uuid = uuid;
      uuidBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (indexBuildStage == STAGE_INITIALIZING) attributes.add("index");
      if (uuidBuildStage == STAGE_INITIALIZING) attributes.add("uuid");
      return "Cannot build DefaultDerivedInit, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The computed-at-construction value of the {@code index} attribute
   */
  @Override
  public String index() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.index()
        : this.index;
  }

  /**
   * @return The value of the {@code uuid} attribute
   */
  @Override
  public String uuid() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.uuid()
        : this.uuid;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @Override
  public String title() {
    return title;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultDerivedInit#uuid() uuid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for uuid
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDefaultDerivedInit withUuid(String value) {
    String newValue = Objects.requireNonNull(value, "uuid");
    if (this.uuid.equals(newValue)) return this;
    return new ImmutableDefaultDerivedInit(this, newValue, this.title);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultDerivedInit#title() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDefaultDerivedInit withTitle(String value) {
    String newValue = Objects.requireNonNull(value, "title");
    if (this.title.equals(newValue)) return this;
    return new ImmutableDefaultDerivedInit(this, this.uuid, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDefaultDerivedInit} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDefaultDerivedInit
        && equalTo(0, (ImmutableDefaultDerivedInit) another);
  }

  private boolean equalTo(int synthetic, ImmutableDefaultDerivedInit another) {
    return index.equals(another.index)
        && uuid.equals(another.uuid)
        && title.equals(another.title);
  }

  /**
   * Computes a hash code from attributes: {@code index}, {@code uuid}, {@code title}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + index.hashCode();
    h += (h << 5) + uuid.hashCode();
    h += (h << 5) + title.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DefaultDerivedInit} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DefaultDerivedInit")
        .omitNullValues()
        .add("index", index)
        .add("uuid", uuid)
        .add("title", title)
        .toString();
  }

  /**
   * Construct a new immutable {@code DefaultDerivedInit} instance.
   * @param uuid The value for the {@code uuid} attribute
   * @param title The value for the {@code title} attribute
   * @return An immutable DefaultDerivedInit instance
   */
  public static ImmutableDefaultDerivedInit of(String uuid, String title) {
    return new ImmutableDefaultDerivedInit(uuid, title);
  }

  /**
   * Creates an immutable copy of a {@link DefaultDerivedInit} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DefaultDerivedInit instance
   */
  public static ImmutableDefaultDerivedInit copyOf(DefaultDerivedInit instance) {
    if (instance instanceof ImmutableDefaultDerivedInit) {
      return (ImmutableDefaultDerivedInit) instance;
    }
    return ImmutableDefaultDerivedInit.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDefaultDerivedInit ImmutableDefaultDerivedInit}.
   * <pre>
   * ImmutableDefaultDerivedInit.builder()
   *    .uuid(String) // optional {@link DefaultDerivedInit#uuid() uuid}
   *    .title(String) // required {@link DefaultDerivedInit#title() title}
   *    .build();
   * </pre>
   * @return A new ImmutableDefaultDerivedInit builder
   */
  public static ImmutableDefaultDerivedInit.Builder builder() {
    return new ImmutableDefaultDerivedInit.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDefaultDerivedInit ImmutableDefaultDerivedInit}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultDerivedInit", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TITLE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String uuid;
    private @Nullable String title;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DefaultDerivedInit} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DefaultDerivedInit instance) {
      Objects.requireNonNull(instance, "instance");
      uuid(instance.uuid());
      title(instance.title());
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultDerivedInit#uuid() uuid} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DefaultDerivedInit#uuid() uuid}.</em>
     * @param uuid The value for uuid 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder uuid(String uuid) {
      this.uuid = Objects.requireNonNull(uuid, "uuid");
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultDerivedInit#title() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDefaultDerivedInit ImmutableDefaultDerivedInit}.
     * @return An immutable instance of DefaultDerivedInit
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDefaultDerivedInit build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDefaultDerivedInit(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TITLE) != 0) attributes.add("title");
      return "Cannot build DefaultDerivedInit, some of required attributes are not set " + attributes;
    }
  }
}
