package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DerivedNotInConstructorSimpleCons}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDerivedNotInConstructorSimpleCons.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDerivedNotInConstructorSimpleCons.of()}.
 */
@Generated(from = "DerivedNotInConstructorSimpleCons", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableDerivedNotInConstructorSimpleCons
    extends DerivedNotInConstructorSimpleCons {
  private final int a;
  private transient final int b;

  private ImmutableDerivedNotInConstructorSimpleCons(int a) {
    this.a = a;
    this.b = super.b();
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The computed-at-construction value of the {@code b} attribute
   */
  @Override
  public int b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DerivedNotInConstructorSimpleCons#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDerivedNotInConstructorSimpleCons withA(int value) {
    if (this.a == value) return this;
    return new ImmutableDerivedNotInConstructorSimpleCons(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDerivedNotInConstructorSimpleCons} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDerivedNotInConstructorSimpleCons
        && equalTo(0, (ImmutableDerivedNotInConstructorSimpleCons) another);
  }

  private boolean equalTo(int synthetic, ImmutableDerivedNotInConstructorSimpleCons another) {
    return a == another.a
        && b == another.b;
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b;
    return h;
  }

  /**
   * Prints the immutable value {@code DerivedNotInConstructorSimpleCons} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DerivedNotInConstructorSimpleCons")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Construct a new immutable {@code DerivedNotInConstructorSimpleCons} instance.
   * @param a The value for the {@code a} attribute
   * @return An immutable DerivedNotInConstructorSimpleCons instance
   */
  public static ImmutableDerivedNotInConstructorSimpleCons of(int a) {
    return new ImmutableDerivedNotInConstructorSimpleCons(a);
  }

  /**
   * Creates an immutable copy of a {@link DerivedNotInConstructorSimpleCons} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DerivedNotInConstructorSimpleCons instance
   */
  public static ImmutableDerivedNotInConstructorSimpleCons copyOf(DerivedNotInConstructorSimpleCons instance) {
    if (instance instanceof ImmutableDerivedNotInConstructorSimpleCons) {
      return (ImmutableDerivedNotInConstructorSimpleCons) instance;
    }
    return ImmutableDerivedNotInConstructorSimpleCons.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDerivedNotInConstructorSimpleCons ImmutableDerivedNotInConstructorSimpleCons}.
   * <pre>
   * ImmutableDerivedNotInConstructorSimpleCons.builder()
   *    .a(int) // required {@link DerivedNotInConstructorSimpleCons#a() a}
   *    .build();
   * </pre>
   * @return A new ImmutableDerivedNotInConstructorSimpleCons builder
   */
  public static ImmutableDerivedNotInConstructorSimpleCons.Builder builder() {
    return new ImmutableDerivedNotInConstructorSimpleCons.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDerivedNotInConstructorSimpleCons ImmutableDerivedNotInConstructorSimpleCons}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DerivedNotInConstructorSimpleCons", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private int a;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DerivedNotInConstructorSimpleCons} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DerivedNotInConstructorSimpleCons instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      return this;
    }

    /**
     * Initializes the value for the {@link DerivedNotInConstructorSimpleCons#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDerivedNotInConstructorSimpleCons ImmutableDerivedNotInConstructorSimpleCons}.
     * @return An immutable instance of DerivedNotInConstructorSimpleCons
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDerivedNotInConstructorSimpleCons build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDerivedNotInConstructorSimpleCons(a);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build DerivedNotInConstructorSimpleCons, some of required attributes are not set " + attributes;
    }
  }
}
