package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExtraCollection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExtraCollection.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableExtraCollection.of()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableExtraCollection.of()}.
 */
@Generated(from = "ExtraCollection", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableExtraCollection implements ExtraCollection {
  private final ImmutableMultiset<String> bag;
  private final ImmutableMultimap<Integer, String> index;
  private final ImmutableListMultimap<Integer, String> indexList;
  private final ImmutableSetMultimap<Integer, String> indexSet;
  private final ImmutableBiMap<Integer, String> biMap;
  private transient final int hashCode;

  private ImmutableExtraCollection() {
    this.bag = ImmutableMultiset.of();
    this.index = ImmutableMultimap.of();
    this.indexList = ImmutableListMultimap.of();
    this.indexSet = ImmutableSetMultimap.of();
    this.biMap = ImmutableBiMap.of();
    this.hashCode = computeHashCode();
  }

  private ImmutableExtraCollection(
      Iterable<String> bag,
      Multimap<Integer, ? extends String> index,
      Multimap<Integer, ? extends String> indexList,
      Multimap<Integer, ? extends String> indexSet,
      Map<Integer, ? extends String> biMap) {
    this.bag = ImmutableMultiset.copyOf(bag);
    this.index = ImmutableMultimap.copyOf(index);
    this.indexList = ImmutableListMultimap.copyOf(indexList);
    this.indexSet = ImmutableSetMultimap.copyOf(indexSet);
    this.biMap = ImmutableBiMap.copyOf(biMap);
    this.hashCode = computeHashCode();
  }

  private ImmutableExtraCollection(
      ImmutableExtraCollection original,
      ImmutableMultiset<String> bag,
      ImmutableMultimap<Integer, String> index,
      ImmutableListMultimap<Integer, String> indexList,
      ImmutableSetMultimap<Integer, String> indexSet,
      ImmutableBiMap<Integer, String> biMap) {
    this.bag = bag;
    this.index = index;
    this.indexList = indexList;
    this.indexSet = indexSet;
    this.biMap = biMap;
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code bag} attribute
   */
  @Override
  public ImmutableMultiset<String> bag() {
    return bag;
  }

  /**
   * @return The value of the {@code index} attribute
   */
  @Override
  public ImmutableMultimap<Integer, String> index() {
    return index;
  }

  /**
   * @return The value of the {@code indexList} attribute
   */
  @Override
  public ImmutableListMultimap<Integer, String> indexList() {
    return indexList;
  }

  /**
   * @return The value of the {@code indexSet} attribute
   */
  @Override
  public ImmutableSetMultimap<Integer, String> indexSet() {
    return indexSet;
  }

  /**
   * @return The value of the {@code biMap} attribute
   */
  @Override
  public ImmutableBiMap<Integer, String> biMap() {
    return biMap;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtraCollection#bag() bag}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExtraCollection withBag(String... elements) {
    ImmutableMultiset<String> newValue = ImmutableMultiset.copyOf(elements);
    return validate(new ImmutableExtraCollection(this, newValue, this.index, this.indexList, this.indexSet, this.biMap));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtraCollection#bag() bag}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of bag elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExtraCollection withBag(Iterable<String> elements) {
    if (this.bag == elements) return this;
    ImmutableMultiset<String> newValue = ImmutableMultiset.copyOf(elements);
    return validate(new ImmutableExtraCollection(this, newValue, this.index, this.indexList, this.indexSet, this.biMap));
  }

  /**
   * Copy the current immutable object by replacing the {@link ExtraCollection#index() index} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the index map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExtraCollection withIndex(Multimap<Integer, ? extends String> entries) {
    if (this.index == entries) return this;
    ImmutableMultimap<Integer, String> newValue = ImmutableMultimap.copyOf(entries);
    return validate(new ImmutableExtraCollection(this, this.bag, newValue, this.indexList, this.indexSet, this.biMap));
  }

  /**
   * Copy the current immutable object by replacing the {@link ExtraCollection#indexList() indexList} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the indexList map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExtraCollection withIndexList(Multimap<Integer, ? extends String> entries) {
    if (this.indexList == entries) return this;
    ImmutableListMultimap<Integer, String> newValue = ImmutableListMultimap.copyOf(entries);
    return validate(new ImmutableExtraCollection(this, this.bag, this.index, newValue, this.indexSet, this.biMap));
  }

  /**
   * Copy the current immutable object by replacing the {@link ExtraCollection#indexSet() indexSet} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the indexSet map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExtraCollection withIndexSet(Multimap<Integer, ? extends String> entries) {
    if (this.indexSet == entries) return this;
    ImmutableSetMultimap<Integer, String> newValue = ImmutableSetMultimap.copyOf(entries);
    return validate(new ImmutableExtraCollection(this, this.bag, this.index, this.indexList, newValue, this.biMap));
  }

  /**
   * Copy the current immutable object by replacing the {@link ExtraCollection#biMap() biMap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the biMap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExtraCollection withBiMap(Map<Integer, ? extends String> entries) {
    if (this.biMap == entries) return this;
    ImmutableBiMap<Integer, String> newValue = ImmutableBiMap.copyOf(entries);
    return validate(new ImmutableExtraCollection(this, this.bag, this.index, this.indexList, this.indexSet, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExtraCollection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExtraCollection
        && equalTo(0, (ImmutableExtraCollection) another);
  }

  private boolean equalTo(int synthetic, ImmutableExtraCollection another) {
    if (hashCode != another.hashCode) return false;
    return bag.equals(another.bag)
        && index.equals(another.index)
        && indexList.equals(another.indexList)
        && indexSet.equals(another.indexSet)
        && biMap.equals(another.biMap);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code bag}, {@code index}, {@code indexList}, {@code indexSet}, {@code biMap}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + bag.hashCode();
    h += (h << 5) + index.hashCode();
    h += (h << 5) + indexList.hashCode();
    h += (h << 5) + indexSet.hashCode();
    h += (h << 5) + biMap.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExtraCollection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExtraCollection")
        .omitNullValues()
        .add("bag", bag)
        .add("index", index)
        .add("indexList", indexList)
        .add("indexSet", indexSet)
        .add("biMap", biMap)
        .toString();
  }

  private static final ImmutableExtraCollection INSTANCE = validate(new ImmutableExtraCollection());

  /**
   * Returns the default immutable singleton value of {@code ExtraCollection}
   * @return An immutable instance of ExtraCollection
   */
  public static ImmutableExtraCollection of() {
    return INSTANCE;
  }

  /**
   * Construct a new immutable {@code ExtraCollection} instance.
   * @param bag The value for the {@code bag} attribute
   * @param index The value for the {@code index} attribute
   * @param indexList The value for the {@code indexList} attribute
   * @param indexSet The value for the {@code indexSet} attribute
   * @param biMap The value for the {@code biMap} attribute
   * @return An immutable ExtraCollection instance
   */
  public static ImmutableExtraCollection of(Multiset<String> bag, Multimap<Integer, String> index, ListMultimap<Integer, String> indexList, SetMultimap<Integer, String> indexSet, BiMap<Integer, String> biMap) {
    return of((Iterable<String>) bag, index, (Multimap<Integer, ? extends String>) indexList, (Multimap<Integer, ? extends String>) indexSet, (Map<Integer, ? extends String>) biMap);
  }

  /**
   * Construct a new immutable {@code ExtraCollection} instance.
   * @param bag The value for the {@code bag} attribute
   * @param index The value for the {@code index} attribute
   * @param indexList The value for the {@code indexList} attribute
   * @param indexSet The value for the {@code indexSet} attribute
   * @param biMap The value for the {@code biMap} attribute
   * @return An immutable ExtraCollection instance
   */
  public static ImmutableExtraCollection of(Iterable<String> bag, Multimap<Integer, ? extends String> index, Multimap<Integer, ? extends String> indexList, Multimap<Integer, ? extends String> indexSet, Map<Integer, ? extends String> biMap) {
    return validate(new ImmutableExtraCollection(bag, index, indexList, indexSet, biMap));
  }

  private static ImmutableExtraCollection validate(ImmutableExtraCollection instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link ExtraCollection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExtraCollection instance
   */
  public static ImmutableExtraCollection copyOf(ExtraCollection instance) {
    if (instance instanceof ImmutableExtraCollection) {
      return (ImmutableExtraCollection) instance;
    }
    return ImmutableExtraCollection.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExtraCollection ImmutableExtraCollection}.
   * <pre>
   * ImmutableExtraCollection.builder()
   *    .addBag|addAllBag(String) // {@link ExtraCollection#bag() bag} elements
   *    .putIndex|putAllIndex(int =&gt; String) // {@link ExtraCollection#index() index} mappings
   *    .putIndexList|putAllIndexList(int =&gt; String) // {@link ExtraCollection#indexList() indexList} mappings
   *    .putIndexSet|putAllIndexSet(int =&gt; String) // {@link ExtraCollection#indexSet() indexSet} mappings
   *    .putBiMap|putAllBiMap(int =&gt; String) // {@link ExtraCollection#biMap() biMap} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableExtraCollection builder
   */
  public static ImmutableExtraCollection.Builder builder() {
    return new ImmutableExtraCollection.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExtraCollection ImmutableExtraCollection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExtraCollection", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableMultiset.Builder<String> bag = ImmutableMultiset.builder();
    private ImmutableMultimap.Builder<Integer, String> index = ImmutableMultimap.builder();
    private ImmutableListMultimap.Builder<Integer, String> indexList = ImmutableListMultimap.builder();
    private ImmutableSetMultimap.Builder<Integer, String> indexSet = ImmutableSetMultimap.builder();
    private ImmutableBiMap.Builder<Integer, String> biMap = ImmutableBiMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExtraCollection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ExtraCollection instance) {
      Objects.requireNonNull(instance, "instance");
      addAllBag(instance.bag());
      putAllIndex(instance.index());
      putAllIndexList(instance.indexList());
      putAllIndexSet(instance.indexSet());
      putAllBiMap(instance.biMap());
      return this;
    }

    /**
     * Adds one element to {@link ExtraCollection#bag() bag} multiset.
     * @param element A bag element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBag(String element) {
      this.bag.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ExtraCollection#bag() bag} multiset.
     * @param elements An array of bag elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBag(String... elements) {
      this.bag.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ExtraCollection#bag() bag} multiset.
     * @param elements An iterable of bag elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bag(Iterable<String> elements) {
      this.bag = ImmutableMultiset.builder();
      return addAllBag(elements);
    }

    /**
     * Adds elements to {@link ExtraCollection#bag() bag} multiset.
     * @param elements An iterable of bag elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllBag(Iterable<String> elements) {
      this.bag.addAll(elements);
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link ExtraCollection#index() index} true. Nulls are not permitted
     * @param key The key for index
     * @param values The values for index
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putIndex(int key, String... values) {
      this.index.putAll(key, Arrays.asList(values));
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link ExtraCollection#index() index} true. Nulls are not permitted
     * @param key The key for index
     * @param values The values for index
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllIndex(int key, Iterable<String> values) {
      this.index.putAll(key, values);
      return this;
    }

    /**
     * Put one entry to the {@link ExtraCollection#index() index} map.
     * @param key The key in the index map
     * @param value The associated value in the index map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putIndex(int key, String value) {
      this.index.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ExtraCollection#index() index} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putIndex(Map.Entry<Integer, ? extends String> entry) {
      this.index.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ExtraCollection#index() index} map. Nulls are not permitted
     * @param entries The entries that will be added to the index map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder index(Multimap<Integer, ? extends String> entries) {
      this.index = ImmutableMultimap.builder();
      return putAllIndex(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ExtraCollection#index() index} map. Nulls are not permitted
     * @param entries The entries that will be added to the index map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllIndex(Multimap<Integer, ? extends String> entries) {
      this.index.putAll(entries);
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link ExtraCollection#indexList() indexList} true. Nulls are not permitted
     * @param key The key for indexList
     * @param values The values for indexList
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putIndexList(int key, String... values) {
      this.indexList.putAll(key, Arrays.asList(values));
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link ExtraCollection#indexList() indexList} true. Nulls are not permitted
     * @param key The key for indexList
     * @param values The values for indexList
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllIndexList(int key, Iterable<String> values) {
      this.indexList.putAll(key, values);
      return this;
    }

    /**
     * Put one entry to the {@link ExtraCollection#indexList() indexList} map.
     * @param key The key in the indexList map
     * @param value The associated value in the indexList map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putIndexList(int key, String value) {
      this.indexList.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ExtraCollection#indexList() indexList} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putIndexList(Map.Entry<Integer, ? extends String> entry) {
      this.indexList.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ExtraCollection#indexList() indexList} map. Nulls are not permitted
     * @param entries The entries that will be added to the indexList map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder indexList(Multimap<Integer, ? extends String> entries) {
      this.indexList = ImmutableListMultimap.builder();
      return putAllIndexList(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ExtraCollection#indexList() indexList} map. Nulls are not permitted
     * @param entries The entries that will be added to the indexList map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllIndexList(Multimap<Integer, ? extends String> entries) {
      this.indexList.putAll(entries);
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link ExtraCollection#indexSet() indexSet} true. Nulls are not permitted
     * @param key The key for indexSet
     * @param values The values for indexSet
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putIndexSet(int key, String... values) {
      this.indexSet.putAll(key, Arrays.asList(values));
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link ExtraCollection#indexSet() indexSet} true. Nulls are not permitted
     * @param key The key for indexSet
     * @param values The values for indexSet
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllIndexSet(int key, Iterable<String> values) {
      this.indexSet.putAll(key, values);
      return this;
    }

    /**
     * Put one entry to the {@link ExtraCollection#indexSet() indexSet} map.
     * @param key The key in the indexSet map
     * @param value The associated value in the indexSet map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putIndexSet(int key, String value) {
      this.indexSet.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ExtraCollection#indexSet() indexSet} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putIndexSet(Map.Entry<Integer, ? extends String> entry) {
      this.indexSet.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ExtraCollection#indexSet() indexSet} map. Nulls are not permitted
     * @param entries The entries that will be added to the indexSet map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder indexSet(Multimap<Integer, ? extends String> entries) {
      this.indexSet = ImmutableSetMultimap.builder();
      return putAllIndexSet(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ExtraCollection#indexSet() indexSet} map. Nulls are not permitted
     * @param entries The entries that will be added to the indexSet map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllIndexSet(Multimap<Integer, ? extends String> entries) {
      this.indexSet.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link ExtraCollection#biMap() biMap} map.
     * @param key The key in the biMap map
     * @param value The associated value in the biMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putBiMap(int key, String value) {
      this.biMap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ExtraCollection#biMap() biMap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putBiMap(Map.Entry<Integer, ? extends String> entry) {
      this.biMap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ExtraCollection#biMap() biMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the biMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder biMap(Map<Integer, ? extends String> entries) {
      this.biMap = ImmutableBiMap.builder();
      return putAllBiMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ExtraCollection#biMap() biMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the biMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllBiMap(Map<Integer, ? extends String> entries) {
      this.biMap.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExtraCollection ImmutableExtraCollection}.
     * @return An immutable instance of ExtraCollection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExtraCollection build() {
      return ImmutableExtraCollection.validate(new ImmutableExtraCollection(null, bag.build(), index.build(), indexList.build(), indexSet.build(), biMap.build()));
    }
  }
}
