package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HasInheritedFinalMethod}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHasInheritedFinalMethod.builder()}.
 */
@Generated(from = "HasInheritedFinalMethod", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHasInheritedFinalMethod extends HasInheritedFinalMethod {

  private ImmutableHasInheritedFinalMethod(ImmutableHasInheritedFinalMethod.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHasInheritedFinalMethod} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHasInheritedFinalMethod
        && equalTo(0, (ImmutableHasInheritedFinalMethod) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableHasInheritedFinalMethod another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 219252254;
  }

  /**
   * Prints the immutable value {@code HasInheritedFinalMethod}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "HasInheritedFinalMethod{}";
  }

  /**
   * Creates an immutable copy of a {@link HasInheritedFinalMethod} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HasInheritedFinalMethod instance
   */
  public static ImmutableHasInheritedFinalMethod copyOf(HasInheritedFinalMethod instance) {
    if (instance instanceof ImmutableHasInheritedFinalMethod) {
      return (ImmutableHasInheritedFinalMethod) instance;
    }
    return ImmutableHasInheritedFinalMethod.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHasInheritedFinalMethod ImmutableHasInheritedFinalMethod}.
   * <pre>
   * ImmutableHasInheritedFinalMethod.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableHasInheritedFinalMethod builder
   */
  public static ImmutableHasInheritedFinalMethod.Builder builder() {
    return new ImmutableHasInheritedFinalMethod.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHasInheritedFinalMethod ImmutableHasInheritedFinalMethod}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HasInheritedFinalMethod", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HasInheritedFinalMethod} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HasInheritedFinalMethod instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableHasInheritedFinalMethod ImmutableHasInheritedFinalMethod}.
     * @return An immutable instance of HasInheritedFinalMethod
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHasInheritedFinalMethod build() {
      return new ImmutableHasInheritedFinalMethod(this);
    }
  }
}
