package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HostWithPort}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHostWithPort.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableHostWithPort.of()}.
 */
@Generated(from = "HostWithPort", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHostWithPort extends HostWithPort {
  private final String hostname;
  private final int port;

  private ImmutableHostWithPort(int port, String hostname) {
    this.port = port;
    this.hostname = Objects.requireNonNull(hostname, "hostname");
  }

  private ImmutableHostWithPort(ImmutableHostWithPort original, String hostname, int port) {
    this.hostname = hostname;
    this.port = port;
  }

  /**
   * @return The value of the {@code hostname} attribute
   */
  @Override
  public String hostname() {
    return hostname;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @Override
  public int port() {
    return port;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostWithPort#hostname() hostname} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hostname
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostWithPort withHostname(String value) {
    String newValue = Objects.requireNonNull(value, "hostname");
    if (this.hostname.equals(newValue)) return this;
    return new ImmutableHostWithPort(this, newValue, this.port);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HostWithPort#port() port} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostWithPort withPort(int value) {
    if (this.port == value) return this;
    return new ImmutableHostWithPort(this, this.hostname, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHostWithPort} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHostWithPort
        && equalTo(0, (ImmutableHostWithPort) another);
  }

  private boolean equalTo(int synthetic, ImmutableHostWithPort another) {
    return hostname.equals(another.hostname)
        && port == another.port;
  }

  /**
   * Computes a hash code from attributes: {@code hostname}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + hostname.hashCode();
    h += (h << 5) + port;
    return h;
  }

  /**
   * Prints the immutable value {@code HostWithPort} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HostWithPort")
        .omitNullValues()
        .add("hostname", hostname)
        .add("port", port)
        .toString();
  }

  /**
   * Construct a new immutable {@code HostWithPort} instance.
   * @param port The value for the {@code port} attribute
   * @param hostname The value for the {@code hostname} attribute
   * @return An immutable HostWithPort instance
   */
  public static ImmutableHostWithPort of(int port, String hostname) {
    return new ImmutableHostWithPort(port, hostname);
  }

  /**
   * Creates an immutable copy of a {@link HostWithPort} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HostWithPort instance
   */
  public static ImmutableHostWithPort copyOf(HostWithPort instance) {
    if (instance instanceof ImmutableHostWithPort) {
      return (ImmutableHostWithPort) instance;
    }
    return ImmutableHostWithPort.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHostWithPort ImmutableHostWithPort}.
   * <pre>
   * ImmutableHostWithPort.builder()
   *    .hostname(String) // required {@link HostWithPort#hostname() hostname}
   *    .port(int) // required {@link HostWithPort#port() port}
   *    .build();
   * </pre>
   * @return A new ImmutableHostWithPort builder
   */
  public static ImmutableHostWithPort.Builder builder() {
    return new ImmutableHostWithPort.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHostWithPort ImmutableHostWithPort}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HostWithPort", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_HOSTNAME = 0x1L;
    private static final long INIT_BIT_PORT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String hostname;
    private int port;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HostWithPort} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HostWithPort instance) {
      Objects.requireNonNull(instance, "instance");
      hostname(instance.hostname());
      port(instance.port());
      return this;
    }

    /**
     * Initializes the value for the {@link HostWithPort#hostname() hostname} attribute.
     * @param hostname The value for hostname 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hostname(String hostname) {
      this.hostname = Objects.requireNonNull(hostname, "hostname");
      initBits &= ~INIT_BIT_HOSTNAME;
      return this;
    }

    /**
     * Initializes the value for the {@link HostWithPort#port() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder port(int port) {
      this.port = port;
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHostWithPort ImmutableHostWithPort}.
     * @return An immutable instance of HostWithPort
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHostWithPort build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHostWithPort(null, hostname, port);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HOSTNAME) != 0) attributes.add("hostname");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      return "Cannot build HostWithPort, some of required attributes are not set " + attributes;
    }
  }
}
