package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link IfaceValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIfaceValue.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableIfaceValue.of()}.
 */
@Generated(from = "IfaceValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableIfaceValue implements IfaceValue {
  private final int number;
  private final ImmutableList<String> auxiliary;
  private transient final int get;

  private ImmutableIfaceValue(int number) {
    this.number = number;
    this.auxiliary = ImmutableList.of();
    this.get = IfaceValue.super.get();
  }

  private ImmutableIfaceValue(int number, ImmutableList<String> auxiliary) {
    this.number = number;
    this.auxiliary = auxiliary;
    this.get = IfaceValue.super.get();
  }

  /**
   * @return The value of the {@code number} attribute
   */
  @Override
  public int getNumber() {
    return number;
  }

  /**
   * @return The value of the {@code auxiliary} attribute
   */
  @Override
  public ImmutableList<String> auxiliary() {
    return auxiliary;
  }

  /**
   * @return The computed-at-construction value of the {@code get} attribute
   */
  @Override
  public int get() {
    return get;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IfaceValue#getNumber() number} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for number
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIfaceValue withNumber(int value) {
    if (this.number == value) return this;
    return new ImmutableIfaceValue(value, this.auxiliary);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IfaceValue#auxiliary() auxiliary}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIfaceValue withAuxiliary(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableIfaceValue(this.number, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link IfaceValue#auxiliary() auxiliary}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of auxiliary elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIfaceValue withAuxiliary(Iterable<String> elements) {
    if (this.auxiliary == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableIfaceValue(this.number, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIfaceValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIfaceValue
        && equalTo(0, (ImmutableIfaceValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableIfaceValue another) {
    return number == another.number;
  }

  /**
   * Computes a hash code from attributes: {@code number}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + number;
    return h;
  }

  /**
   * Prints the immutable value {@code IfaceValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IfaceValue")
        .omitNullValues()
        .add("number", number)
        .toString();
  }

  /**
   * Construct a new immutable {@code IfaceValue} instance.
   * @param number The value for the {@code number} attribute
   * @return An immutable IfaceValue instance
   */
  public static ImmutableIfaceValue of(int number) {
    return new ImmutableIfaceValue(number);
  }

  /**
   * Creates an immutable copy of a {@link IfaceValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IfaceValue instance
   */
  public static ImmutableIfaceValue copyOf(IfaceValue instance) {
    if (instance instanceof ImmutableIfaceValue) {
      return (ImmutableIfaceValue) instance;
    }
    return ImmutableIfaceValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableIfaceValue ImmutableIfaceValue}.
   * <pre>
   * ImmutableIfaceValue.builder()
   *    .number(int) // required {@link IfaceValue#getNumber() number}
   *    .addAuxiliary|addAllAuxiliary(String) // {@link IfaceValue#auxiliary() auxiliary} elements
   *    .build();
   * </pre>
   * @return A new ImmutableIfaceValue builder
   */
  public static ImmutableIfaceValue.Builder builder() {
    return new ImmutableIfaceValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIfaceValue ImmutableIfaceValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IfaceValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NUMBER = 0x1L;
    private long initBits = 0x1L;

    private int number;
    private ImmutableList.Builder<String> auxiliary = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code IfaceValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(IfaceValue instance) {
      Objects.requireNonNull(instance, "instance");
      number(instance.getNumber());
      addAllAuxiliary(instance.auxiliary());
      return this;
    }

    /**
     * Initializes the value for the {@link IfaceValue#getNumber() number} attribute.
     * @param number The value for number 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder number(int number) {
      this.number = number;
      initBits &= ~INIT_BIT_NUMBER;
      return this;
    }

    /**
     * Adds one element to {@link IfaceValue#auxiliary() auxiliary} list.
     * @param element A auxiliary element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAuxiliary(String element) {
      this.auxiliary.add(element);
      return this;
    }

    /**
     * Adds elements to {@link IfaceValue#auxiliary() auxiliary} list.
     * @param elements An array of auxiliary elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAuxiliary(String... elements) {
      this.auxiliary.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link IfaceValue#auxiliary() auxiliary} list.
     * @param elements An iterable of auxiliary elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder auxiliary(Iterable<String> elements) {
      this.auxiliary = ImmutableList.builder();
      return addAllAuxiliary(elements);
    }

    /**
     * Adds elements to {@link IfaceValue#auxiliary() auxiliary} list.
     * @param elements An iterable of auxiliary elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllAuxiliary(Iterable<String> elements) {
      this.auxiliary.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableIfaceValue ImmutableIfaceValue}.
     * @return An immutable instance of IfaceValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIfaceValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableIfaceValue(number, auxiliary.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NUMBER) != 0) attributes.add("number");
      return "Cannot build IfaceValue, some of required attributes are not set " + attributes;
    }
  }
}
