package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BuildFromCovariants.ItemSimple}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItemSimple.builder()}.
 */
@Generated(from = "BuildFromCovariants.ItemSimple", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableItemSimple extends BuildFromCovariants.ItemSimple {
  private final Integer id;
  private final String uid;

  private ImmutableItemSimple(Integer id, String uid) {
    this.id = id;
    this.uid = uid;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public Integer id() {
    return id;
  }

  /**
   * @return The value of the {@code uid} attribute
   */
  @Override
  public String uid() {
    return uid;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BuildFromCovariants.ItemSimple#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemSimple withId(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableItemSimple(newValue, this.uid);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BuildFromCovariants.ItemSimple#uid() uid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for uid
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemSimple withUid(String value) {
    String newValue = Objects.requireNonNull(value, "uid");
    if (this.uid.equals(newValue)) return this;
    return new ImmutableItemSimple(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItemSimple} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItemSimple
        && equalTo(0, (ImmutableItemSimple) another);
  }

  private boolean equalTo(int synthetic, ImmutableItemSimple another) {
    return id.equals(another.id)
        && uid.equals(another.uid);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code uid}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + uid.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ItemSimple} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ItemSimple")
        .omitNullValues()
        .add("id", id)
        .add("uid", uid)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link BuildFromCovariants.ItemSimple} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ItemSimple instance
   */
  public static ImmutableItemSimple copyOf(BuildFromCovariants.ItemSimple instance) {
    if (instance instanceof ImmutableItemSimple) {
      return (ImmutableItemSimple) instance;
    }
    return ImmutableItemSimple.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItemSimple ImmutableItemSimple}.
   * <pre>
   * ImmutableItemSimple.builder()
   *    .id(Integer) // required {@link BuildFromCovariants.ItemSimple#id() id}
   *    .uid(String) // required {@link BuildFromCovariants.ItemSimple#uid() uid}
   *    .build();
   * </pre>
   * @return A new ImmutableItemSimple builder
   */
  public static ImmutableItemSimple.Builder builder() {
    return new ImmutableItemSimple.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItemSimple ImmutableItemSimple}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BuildFromCovariants.ItemSimple", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_UID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Integer id;
    private @Nullable String uid;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.BuildFromCovariants.Item} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BuildFromCovariants.Item instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.BuildFromCovariants.ItemSimple} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BuildFromCovariants.ItemSimple instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof BuildFromCovariants.Item) {
        BuildFromCovariants.Item instance = (BuildFromCovariants.Item) object;
        if ((bits & 0x1L) == 0) {
          uid(instance.uid());
          bits |= 0x1L;
        }
      }
      if (object instanceof BuildFromCovariants.ItemSimple) {
        BuildFromCovariants.ItemSimple instance = (BuildFromCovariants.ItemSimple) object;
        if ((bits & 0x1L) == 0) {
          uid(instance.uid());
          bits |= 0x1L;
        }
        id(instance.id());
      }
    }

    /**
     * Initializes the value for the {@link BuildFromCovariants.ItemSimple#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(Integer id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BuildFromCovariants.ItemSimple#uid() uid} attribute.
     * @param uid The value for uid 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder uid(String uid) {
      this.uid = Objects.requireNonNull(uid, "uid");
      initBits &= ~INIT_BIT_UID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableItemSimple ImmutableItemSimple}.
     * @return An immutable instance of ItemSimple
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItemSimple build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableItemSimple(id, uid);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_UID) != 0) attributes.add("uid");
      return "Cannot build ItemSimple, some of required attributes are not set " + attributes;
    }
  }
}
