package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JavadocDeprecation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJavadocDeprecation.builder()}.
 */
@Generated(from = "JavadocDeprecation", generator = "Immutables")
@SuppressWarnings({"all", "deprecation", "removal"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJavadocDeprecation implements JavadocDeprecation {
  private final String attr;
  private final ImmutableSet<RetentionPolicy> pols;

  private ImmutableJavadocDeprecation(
      String attr,
      ImmutableSet<RetentionPolicy> pols) {
    this.attr = attr;
    this.pols = pols;
  }

  /**
   * @return The value of the {@code attr} attribute
   */
  @Deprecated
  @Override
  public String attr() {
    return attr;
  }

  /**
   * Since
   * @since 1.1
   * @deprecated why
   * @return result
   */
  @Deprecated
  @Override
  public ImmutableSet<RetentionPolicy> pols() {
    return pols;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavadocDeprecation#attr() attr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attr
   * @return A modified copy of the {@code this} object
   */
  @Deprecated
  public final ImmutableJavadocDeprecation withAttr(String value) {
    String newValue = Objects.requireNonNull(value, "attr");
    if (this.attr.equals(newValue)) return this;
    return new ImmutableJavadocDeprecation(newValue, this.pols);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JavadocDeprecation#pols() pols}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableJavadocDeprecation withPols(RetentionPolicy... elements) {
    ImmutableSet<RetentionPolicy> newValue = Sets.immutableEnumSet(Arrays.asList(elements));
    return new ImmutableJavadocDeprecation(this.attr, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JavadocDeprecation#pols() pols}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pols elements to set
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableJavadocDeprecation withPols(Iterable<RetentionPolicy> elements) {
    if (this.pols == elements) return this;
    ImmutableSet<RetentionPolicy> newValue = Sets.immutableEnumSet(elements);
    return new ImmutableJavadocDeprecation(this.attr, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJavadocDeprecation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJavadocDeprecation
        && equalTo(0, (ImmutableJavadocDeprecation) another);
  }

  private boolean equalTo(int synthetic, ImmutableJavadocDeprecation another) {
    return attr.equals(another.attr)
        && pols.equals(another.pols);
  }

  /**
   * Computes a hash code from attributes: {@code attr}, {@code pols}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + attr.hashCode();
    h += (h << 5) + pols.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JavadocDeprecation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("JavadocDeprecation")
        .omitNullValues()
        .add("attr", attr)
        .add("pols", pols)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link JavadocDeprecation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JavadocDeprecation instance
   */
  public static ImmutableJavadocDeprecation copyOf(JavadocDeprecation instance) {
    if (instance instanceof ImmutableJavadocDeprecation) {
      return (ImmutableJavadocDeprecation) instance;
    }
    return ImmutableJavadocDeprecation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJavadocDeprecation ImmutableJavadocDeprecation}.
   * <pre>
   * ImmutableJavadocDeprecation.builder()
   *    .attr(String) // required {@link JavadocDeprecation#attr() attr}
   *    .addPols|addAllPols(annotation.RetentionPolicy) // {@link JavadocDeprecation#pols() pols} elements
   *    .build();
   * </pre>
   * @return A new ImmutableJavadocDeprecation builder
   */
  public static ImmutableJavadocDeprecation.Builder builder() {
    return new ImmutableJavadocDeprecation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJavadocDeprecation ImmutableJavadocDeprecation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JavadocDeprecation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ATTR = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String attr;
    private ImmutableSet.Builder<RetentionPolicy> pols = ImmutableSet.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JavadocDeprecation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JavadocDeprecation instance) {
      Objects.requireNonNull(instance, "instance");
      attr(instance.attr());
      addAllPols(instance.pols());
      return this;
    }

    /**
     * Initializes the value for the {@link JavadocDeprecation#attr() attr} attribute.
     * @param attr The value for attr 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @Deprecated
    public final Builder attr(String attr) {
      this.attr = Objects.requireNonNull(attr, "attr");
      initBits &= ~INIT_BIT_ATTR;
      return this;
    }

    /**
     * Adds one element to {@link JavadocDeprecation#pols() pols} set.
     * @param element A pols element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @Deprecated
    public final Builder addPols(RetentionPolicy element) {
      this.pols.add(element);
      return this;
    }

    /**
     * Adds elements to {@link JavadocDeprecation#pols() pols} set.
     * @param elements An array of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @Deprecated
    public final Builder addPols(RetentionPolicy... elements) {
      this.pols.addAll(Arrays.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JavadocDeprecation#pols() pols} set.
     * @param elements An iterable of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @Deprecated
    public final Builder pols(Iterable<RetentionPolicy> elements) {
      this.pols = ImmutableSet.builder();
      return addAllPols(elements);
    }

    /**
     * Adds elements to {@link JavadocDeprecation#pols() pols} set.
     * @param elements An iterable of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @Deprecated
    public final Builder addAllPols(Iterable<RetentionPolicy> elements) {
      this.pols.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableJavadocDeprecation ImmutableJavadocDeprecation}.
     * @return An immutable instance of JavadocDeprecation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJavadocDeprecation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJavadocDeprecation(attr, Sets.immutableEnumSet(pols.build()));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ATTR) != 0) attributes.add("attr");
      return "Cannot build JavadocDeprecation, some of required attributes are not set " + attributes;
    }
  }
}
