package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NoOriginalFieldCopyMethodConflict}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNoOriginalFieldCopyMethodConflict.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNoOriginalFieldCopyMethodConflict.of()}.
 */
@Generated(from = "NoOriginalFieldCopyMethodConflict", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableNoOriginalFieldCopyMethodConflict
    implements NoOriginalFieldCopyMethodConflict {
  private final int original;
  private final @Nullable Integer hh;
  private final ImmutableList<String> a;

  private ImmutableNoOriginalFieldCopyMethodConflict(int original, @Nullable Integer hh, Iterable<String> a) {
    this.original = original;
    this.hh = hh;
    this.a = ImmutableList.copyOf(a);
  }

  private ImmutableNoOriginalFieldCopyMethodConflict(
      ImmutableNoOriginalFieldCopyMethodConflict original$$,
      int original,
      @Nullable Integer hh,
      ImmutableList<String> a) {
    this.original = original;
    this.hh = hh;
    this.a = a;
  }

  /**
   * @return The value of the {@code original} attribute
   */
  @Override
  public int original() {
    return original;
  }

  /**
   * @return The value of the {@code hh} attribute
   */
  @Override
  public @Nullable Integer hh() {
    return hh;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public ImmutableList<String> a() {
    return a;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoOriginalFieldCopyMethodConflict#original() original} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for original
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoOriginalFieldCopyMethodConflict withOriginal(int value) {
    if (this.original == value) return this;
    return new ImmutableNoOriginalFieldCopyMethodConflict(this, value, this.hh, this.a);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoOriginalFieldCopyMethodConflict#hh() hh} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hh (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoOriginalFieldCopyMethodConflict withHh(@Nullable Integer value) {
    if (Objects.equals(this.hh, value)) return this;
    return new ImmutableNoOriginalFieldCopyMethodConflict(this, this.original, value, this.a);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NoOriginalFieldCopyMethodConflict#a() a}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoOriginalFieldCopyMethodConflict withA(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableNoOriginalFieldCopyMethodConflict(this, this.original, this.hh, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NoOriginalFieldCopyMethodConflict#a() a}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of a elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoOriginalFieldCopyMethodConflict withA(Iterable<String> elements) {
    if (this.a == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableNoOriginalFieldCopyMethodConflict(this, this.original, this.hh, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNoOriginalFieldCopyMethodConflict} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNoOriginalFieldCopyMethodConflict
        && equalTo(0, (ImmutableNoOriginalFieldCopyMethodConflict) another);
  }

  private boolean equalTo(int synthetic, ImmutableNoOriginalFieldCopyMethodConflict another) {
    return original == another.original
        && Objects.equals(hh, another.hh)
        && a.equals(another.a);
  }

  /**
   * Computes a hash code from attributes: {@code original}, {@code hh}, {@code a}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + original;
    h += (h << 5) + Objects.hashCode(hh);
    h += (h << 5) + a.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NoOriginalFieldCopyMethodConflict} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NoOriginalFieldCopyMethodConflict")
        .omitNullValues()
        .add("original", original)
        .add("hh", hh)
        .add("a", a)
        .toString();
  }

  /**
   * Construct a new immutable {@code NoOriginalFieldCopyMethodConflict} instance.
   * @param original The value for the {@code original} attribute
   * @param hh The value for the {@code hh} attribute
   * @param a The value for the {@code a} attribute
   * @return An immutable NoOriginalFieldCopyMethodConflict instance
   */
  public static ImmutableNoOriginalFieldCopyMethodConflict of(int original, @Nullable Integer hh, List<String> a) {
    return of(original, hh, (Iterable<String>) a);
  }

  /**
   * Construct a new immutable {@code NoOriginalFieldCopyMethodConflict} instance.
   * @param original The value for the {@code original} attribute
   * @param hh The value for the {@code hh} attribute
   * @param a The value for the {@code a} attribute
   * @return An immutable NoOriginalFieldCopyMethodConflict instance
   */
  public static ImmutableNoOriginalFieldCopyMethodConflict of(int original, @Nullable Integer hh, Iterable<String> a) {
    return new ImmutableNoOriginalFieldCopyMethodConflict(original, hh, a);
  }

  /**
   * Creates an immutable copy of a {@link NoOriginalFieldCopyMethodConflict} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NoOriginalFieldCopyMethodConflict instance
   */
  public static ImmutableNoOriginalFieldCopyMethodConflict copyOf(NoOriginalFieldCopyMethodConflict instance) {
    if (instance instanceof ImmutableNoOriginalFieldCopyMethodConflict) {
      return (ImmutableNoOriginalFieldCopyMethodConflict) instance;
    }
    return ImmutableNoOriginalFieldCopyMethodConflict.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNoOriginalFieldCopyMethodConflict ImmutableNoOriginalFieldCopyMethodConflict}.
   * <pre>
   * ImmutableNoOriginalFieldCopyMethodConflict.builder()
   *    .original(int) // required {@link NoOriginalFieldCopyMethodConflict#original() original}
   *    .hh(Integer | null) // nullable {@link NoOriginalFieldCopyMethodConflict#hh() hh}
   *    .addA|addAllA(String) // {@link NoOriginalFieldCopyMethodConflict#a() a} elements
   *    .build();
   * </pre>
   * @return A new ImmutableNoOriginalFieldCopyMethodConflict builder
   */
  public static ImmutableNoOriginalFieldCopyMethodConflict.Builder builder() {
    return new ImmutableNoOriginalFieldCopyMethodConflict.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNoOriginalFieldCopyMethodConflict ImmutableNoOriginalFieldCopyMethodConflict}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NoOriginalFieldCopyMethodConflict", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ORIGINAL = 0x1L;
    private long initBits = 0x1L;

    private int original;
    private @Nullable Integer hh;
    private ImmutableList.Builder<String> a = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NoOriginalFieldCopyMethodConflict} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NoOriginalFieldCopyMethodConflict instance) {
      Objects.requireNonNull(instance, "instance");
      original(instance.original());
      @Nullable Integer hhValue = instance.hh();
      if (hhValue != null) {
        hh(hhValue);
      }
      addAllA(instance.a());
      return this;
    }

    /**
     * Initializes the value for the {@link NoOriginalFieldCopyMethodConflict#original() original} attribute.
     * @param original The value for original 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder original(int original) {
      this.original = original;
      initBits &= ~INIT_BIT_ORIGINAL;
      return this;
    }

    /**
     * Initializes the value for the {@link NoOriginalFieldCopyMethodConflict#hh() hh} attribute.
     * @param hh The value for hh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hh(@Nullable Integer hh) {
      this.hh = hh;
      return this;
    }

    /**
     * Adds one element to {@link NoOriginalFieldCopyMethodConflict#a() a} list.
     * @param element A a element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addA(String element) {
      this.a.add(element);
      return this;
    }

    /**
     * Adds elements to {@link NoOriginalFieldCopyMethodConflict#a() a} list.
     * @param elements An array of a elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addA(String... elements) {
      this.a.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NoOriginalFieldCopyMethodConflict#a() a} list.
     * @param elements An iterable of a elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(Iterable<String> elements) {
      this.a = ImmutableList.builder();
      return addAllA(elements);
    }

    /**
     * Adds elements to {@link NoOriginalFieldCopyMethodConflict#a() a} list.
     * @param elements An iterable of a elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllA(Iterable<String> elements) {
      this.a.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableNoOriginalFieldCopyMethodConflict ImmutableNoOriginalFieldCopyMethodConflict}.
     * @return An immutable instance of NoOriginalFieldCopyMethodConflict
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNoOriginalFieldCopyMethodConflict build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNoOriginalFieldCopyMethodConflict(null, original, hh, a.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORIGINAL) != 0) attributes.add("original");
      return "Cannot build NoOriginalFieldCopyMethodConflict, some of required attributes are not set " + attributes;
    }
  }
}
