package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OptionalCast}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOptionalCast.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableOptionalCast.of()}.
 */
@Generated(from = "OptionalCast", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOptionalCast implements OptionalCast {
  private final Optional<String> bar;
  private final Optional<Object> object;
  private final Optional<String[]> stringArray;
  private final Optional<List<Long>> list;

  @SuppressWarnings("unchecked") // safe covariant cast
  private ImmutableOptionalCast(
      Optional<String> bar,
      Optional<? extends Object> object,
      Optional<? extends String[]> stringArray,
      Optional<? extends List<Long>> list) {
    this.bar = bar;
    this.object = (Optional<Object>) object;
    this.stringArray = (Optional<String[]>) stringArray;
    this.list = (Optional<List<Long>>) list;
  }

  private ImmutableOptionalCast(
      ImmutableOptionalCast original,
      Optional<String> bar,
      Optional<Object> object,
      Optional<String[]> stringArray,
      Optional<List<Long>> list) {
    this.bar = bar;
    this.object = object;
    this.stringArray = stringArray;
    this.list = list;
  }

  /**
   * @return The value of the {@code bar} attribute
   */
  @Override
  public Optional<String> getBar() {
    return bar;
  }

  /**
   * @return The value of the {@code object} attribute
   */
  @Override
  public Optional<Object> getObject() {
    return object;
  }

  /**
   * @return The value of the {@code stringArray} attribute
   */
  @Override
  public Optional<String[]> getStringArray() {
    return stringArray;
  }

  /**
   * @return The value of the {@code list} attribute
   */
  @Override
  public Optional<List<Long>> getList() {
    return list;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalCast#getBar() bar} attribute.
   * @param value The value for bar
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalCast withBar(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.bar.equals(newValue)) return this;
    return new ImmutableOptionalCast(this, newValue, this.object, this.stringArray, this.list);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalCast#getBar() bar} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for bar
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalCast withBar(Optional<String> optional) {
    Optional<String> value = optional;
    if (this.bar.equals(value)) return this;
    return new ImmutableOptionalCast(this, value, this.object, this.stringArray, this.list);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalCast#getObject() object} attribute.
   * @param value The value for object
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalCast withObject(Object value) {
    Optional<Object> newValue = Optional.of(value);
    if (this.object.isPresent() && this.object.get() == value) return this;
    return new ImmutableOptionalCast(this, this.bar, newValue, this.stringArray, this.list);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalCast#getObject() object} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for object
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableOptionalCast withObject(Optional<? extends Object> optional) {
    Optional<Object> value = (Optional<Object>) optional;
    if (!this.object.isPresent() && !value.isPresent()) return this;
    if (this.object.isPresent() && value.isPresent() && this.object.get() == value.get()) return this;
    return new ImmutableOptionalCast(this, this.bar, value, this.stringArray, this.list);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalCast#getStringArray() stringArray} attribute.
   * @param value The value for stringArray
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalCast withStringArray(String[] value) {
    Optional<String[]> newValue = Optional.of(value);
    if (this.stringArray.isPresent() && this.stringArray.get() == value) return this;
    return new ImmutableOptionalCast(this, this.bar, this.object, newValue, this.list);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalCast#getStringArray() stringArray} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for stringArray
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableOptionalCast withStringArray(Optional<? extends String[]> optional) {
    Optional<String[]> value = (Optional<String[]>) optional;
    if (!this.stringArray.isPresent() && !value.isPresent()) return this;
    if (this.stringArray.isPresent() && value.isPresent() && this.stringArray.get() == value.get()) return this;
    return new ImmutableOptionalCast(this, this.bar, this.object, value, this.list);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalCast#getList() list} attribute.
   * @param value The value for list
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalCast withList(List<Long> value) {
    Optional<List<Long>> newValue = Optional.of(value);
    if (this.list.isPresent() && this.list.get() == value) return this;
    return new ImmutableOptionalCast(this, this.bar, this.object, this.stringArray, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalCast#getList() list} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for list
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableOptionalCast withList(Optional<? extends List<Long>> optional) {
    Optional<List<Long>> value = (Optional<List<Long>>) optional;
    if (!this.list.isPresent() && !value.isPresent()) return this;
    if (this.list.isPresent() && value.isPresent() && this.list.get() == value.get()) return this;
    return new ImmutableOptionalCast(this, this.bar, this.object, this.stringArray, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOptionalCast} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOptionalCast
        && equalTo(0, (ImmutableOptionalCast) another);
  }

  private boolean equalTo(int synthetic, ImmutableOptionalCast another) {
    return bar.equals(another.bar)
        && object.equals(another.object)
        && stringArray.equals(another.stringArray)
        && list.equals(another.list);
  }

  /**
   * Computes a hash code from attributes: {@code bar}, {@code object}, {@code stringArray}, {@code list}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + bar.hashCode();
    h += (h << 5) + object.hashCode();
    h += (h << 5) + stringArray.hashCode();
    h += (h << 5) + list.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OptionalCast} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OptionalCast")
        .omitNullValues()
        .add("bar", bar.orNull())
        .add("object", object.orNull())
        .add("stringArray", stringArray.orNull())
        .add("list", list.orNull())
        .toString();
  }

  /**
   * Construct a new immutable {@code OptionalCast} instance.
   * @param bar The value for the {@code bar} attribute
   * @param object The value for the {@code object} attribute
   * @param stringArray The value for the {@code stringArray} attribute
   * @param list The value for the {@code list} attribute
   * @return An immutable OptionalCast instance
   */
  public static ImmutableOptionalCast of(Optional<String> bar, Optional<? extends Object> object, Optional<? extends String[]> stringArray, Optional<? extends List<Long>> list) {
    return new ImmutableOptionalCast(bar, object, stringArray, list);
  }

  /**
   * Creates an immutable copy of a {@link OptionalCast} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OptionalCast instance
   */
  public static ImmutableOptionalCast copyOf(OptionalCast instance) {
    if (instance instanceof ImmutableOptionalCast) {
      return (ImmutableOptionalCast) instance;
    }
    return ImmutableOptionalCast.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOptionalCast ImmutableOptionalCast}.
   * <pre>
   * ImmutableOptionalCast.builder()
   *    .bar(String) // optional {@link OptionalCast#getBar() bar}
   *    .object(Object) // optional {@link OptionalCast#getObject() object}
   *    .stringArray(String[]) // optional {@link OptionalCast#getStringArray() stringArray}
   *    .list(List&amp;lt;Long&amp;gt;) // optional {@link OptionalCast#getList() list}
   *    .build();
   * </pre>
   * @return A new ImmutableOptionalCast builder
   */
  public static ImmutableOptionalCast.Builder builder() {
    return new ImmutableOptionalCast.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOptionalCast ImmutableOptionalCast}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OptionalCast", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Optional<String> bar = Optional.absent();
    private Optional<Object> object = Optional.absent();
    private Optional<String[]> stringArray = Optional.absent();
    private Optional<List<Long>> list = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OptionalCast} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OptionalCast instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> barOptional = instance.getBar();
      if (barOptional.isPresent()) {
        bar(barOptional);
      }
      Optional<Object> objectOptional = instance.getObject();
      if (objectOptional.isPresent()) {
        object(objectOptional);
      }
      Optional<String[]> stringArrayOptional = instance.getStringArray();
      if (stringArrayOptional.isPresent()) {
        stringArray(stringArrayOptional);
      }
      Optional<List<Long>> listOptional = instance.getList();
      if (listOptional.isPresent()) {
        list(listOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalCast#getBar() bar} to bar.
     * @param bar The value for bar
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bar(String bar) {
      this.bar = Optional.of(bar);
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalCast#getBar() bar} to bar.
     * @param bar The value for bar
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bar(Optional<String> bar) {
      this.bar = bar;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalCast#getObject() object} to object.
     * @param object The value for object
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder object(Object object) {
      this.object = Optional.of(object);
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalCast#getObject() object} to object.
     * @param object The value for object
     * @return {@code this} builder for use in a chained invocation
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    @CanIgnoreReturnValue 
    public final Builder object(Optional<? extends Object> object) {
      this.object = (Optional<Object>) object;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalCast#getStringArray() stringArray} to stringArray.
     * @param stringArray The value for stringArray
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder stringArray(String[] stringArray) {
      this.stringArray = Optional.of(stringArray);
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalCast#getStringArray() stringArray} to stringArray.
     * @param stringArray The value for stringArray
     * @return {@code this} builder for use in a chained invocation
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    @CanIgnoreReturnValue 
    public final Builder stringArray(Optional<? extends String[]> stringArray) {
      this.stringArray = (Optional<String[]>) stringArray;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalCast#getList() list} to list.
     * @param list The value for list
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder list(List<Long> list) {
      this.list = Optional.of(list);
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalCast#getList() list} to list.
     * @param list The value for list
     * @return {@code this} builder for use in a chained invocation
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    @CanIgnoreReturnValue 
    public final Builder list(Optional<? extends List<Long>> list) {
      this.list = (Optional<List<Long>>) list;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOptionalCast ImmutableOptionalCast}.
     * @return An immutable instance of OptionalCast
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOptionalCast build() {
      return new ImmutableOptionalCast(null, bar, object, stringArray, list);
    }
  }
}
