package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OptionalNumber}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOptionalNumber.builder()}.
 */
@Generated(from = "OptionalNumber", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOptionalNumber implements OptionalNumber {
  private final Optional<BigDecimal> bigDecimal;

  private ImmutableOptionalNumber(Optional<BigDecimal> bigDecimal) {
    this.bigDecimal = bigDecimal;
  }

  /**
   * @return The value of the {@code bigDecimal} attribute
   */
  @Override
  public Optional<BigDecimal> bigDecimal() {
    return bigDecimal;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalNumber#bigDecimal() bigDecimal} attribute.
   * @param value The value for bigDecimal
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalNumber withBigDecimal(BigDecimal value) {
    Optional<BigDecimal> newValue = Optional.of(value);
    if (this.bigDecimal.equals(newValue)) return this;
    return new ImmutableOptionalNumber(newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalNumber#bigDecimal() bigDecimal} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for bigDecimal
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableOptionalNumber withBigDecimal(Optional<? extends BigDecimal> optional) {
    Optional<BigDecimal> value = (Optional<BigDecimal>) optional;
    if (this.bigDecimal.equals(value)) return this;
    return new ImmutableOptionalNumber(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOptionalNumber} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOptionalNumber
        && equalTo(0, (ImmutableOptionalNumber) another);
  }

  private boolean equalTo(int synthetic, ImmutableOptionalNumber another) {
    return bigDecimal.equals(another.bigDecimal);
  }

  /**
   * Computes a hash code from attributes: {@code bigDecimal}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + bigDecimal.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OptionalNumber} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OptionalNumber")
        .omitNullValues()
        .add("bigDecimal", bigDecimal.orNull())
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link OptionalNumber} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OptionalNumber instance
   */
  public static ImmutableOptionalNumber copyOf(OptionalNumber instance) {
    if (instance instanceof ImmutableOptionalNumber) {
      return (ImmutableOptionalNumber) instance;
    }
    return ImmutableOptionalNumber.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOptionalNumber ImmutableOptionalNumber}.
   * <pre>
   * ImmutableOptionalNumber.builder()
   *    .bigDecimal(java.math.BigDecimal) // optional {@link OptionalNumber#bigDecimal() bigDecimal}
   *    .build();
   * </pre>
   * @return A new ImmutableOptionalNumber builder
   */
  public static ImmutableOptionalNumber.Builder builder() {
    return new ImmutableOptionalNumber.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOptionalNumber ImmutableOptionalNumber}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OptionalNumber", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Optional<BigDecimal> bigDecimal = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OptionalNumber} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OptionalNumber instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<BigDecimal> bigDecimalOptional = instance.bigDecimal();
      if (bigDecimalOptional.isPresent()) {
        bigDecimal(bigDecimalOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalNumber#bigDecimal() bigDecimal} to bigDecimal.
     * @param bigDecimal The value for bigDecimal
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bigDecimal(BigDecimal bigDecimal) {
      this.bigDecimal = Optional.of(bigDecimal);
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalNumber#bigDecimal() bigDecimal} to bigDecimal.
     * @param bigDecimal The value for bigDecimal
     * @return {@code this} builder for use in a chained invocation
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    @CanIgnoreReturnValue 
    public final Builder bigDecimal(Optional<? extends BigDecimal> bigDecimal) {
      this.bigDecimal = (Optional<BigDecimal>) bigDecimal;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOptionalNumber ImmutableOptionalNumber}.
     * @return An immutable instance of OptionalNumber
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOptionalNumber build() {
      return new ImmutableOptionalNumber(bigDecimal);
    }
  }
}
