package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OptionalOfOptionalRegular}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOptionalOfOptionalRegular.builder()}.
 */
@Generated(from = "OptionalOfOptionalRegular", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOptionalOfOptionalRegular<T>
    implements OptionalOfOptionalRegular<T> {
  private final Option<Optional<T>> optionalOfOptional;

  private ImmutableOptionalOfOptionalRegular(Option<Optional<T>> optionalOfOptional) {
    this.optionalOfOptional = optionalOfOptional;
  }

  /**
   * @return The value of the {@code optionalOfOptional} attribute
   */
  @Override
  public Option<Optional<T>> optionalOfOptional() {
    return optionalOfOptional;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OptionalOfOptionalRegular#optionalOfOptional() optionalOfOptional} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for optionalOfOptional
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOptionalOfOptionalRegular<T> withOptionalOfOptional(Option<Optional<T>> value) {
    Option<Optional<T>> newValue = Objects.requireNonNull(value, "optionalOfOptional");
    if (this.optionalOfOptional.equals(newValue)) return this;
    return new ImmutableOptionalOfOptionalRegular<>(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOptionalOfOptionalRegular} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOptionalOfOptionalRegular<?>
        && equalTo(0, (ImmutableOptionalOfOptionalRegular<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableOptionalOfOptionalRegular<?> another) {
    return optionalOfOptional.equals(another.optionalOfOptional);
  }

  /**
   * Computes a hash code from attributes: {@code optionalOfOptional}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + optionalOfOptional.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OptionalOfOptionalRegular} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OptionalOfOptionalRegular")
        .omitNullValues()
        .add("optionalOfOptional", optionalOfOptional)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link OptionalOfOptionalRegular} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable OptionalOfOptionalRegular instance
   */
  public static <T> ImmutableOptionalOfOptionalRegular<T> copyOf(OptionalOfOptionalRegular<T> instance) {
    if (instance instanceof ImmutableOptionalOfOptionalRegular<?>) {
      return (ImmutableOptionalOfOptionalRegular<T>) instance;
    }
    return ImmutableOptionalOfOptionalRegular.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOptionalOfOptionalRegular ImmutableOptionalOfOptionalRegular}.
   * <pre>
   * ImmutableOptionalOfOptionalRegular.&amp;lt;T&amp;gt;builder()
   *    .optionalOfOptional(io.atlassian.fugue.Option&amp;lt;com.google.common.base.Optional&amp;lt;T&amp;gt;&amp;gt;) // required {@link OptionalOfOptionalRegular#optionalOfOptional() optionalOfOptional}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableOptionalOfOptionalRegular builder
   */
  public static <T> ImmutableOptionalOfOptionalRegular.Builder<T> builder() {
    return new ImmutableOptionalOfOptionalRegular.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableOptionalOfOptionalRegular ImmutableOptionalOfOptionalRegular}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OptionalOfOptionalRegular", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_OPTIONAL_OF_OPTIONAL = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Option<Optional<T>> optionalOfOptional;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OptionalOfOptionalRegular} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(OptionalOfOptionalRegular<T> instance) {
      Objects.requireNonNull(instance, "instance");
      optionalOfOptional(instance.optionalOfOptional());
      return this;
    }

    /**
     * Initializes the value for the {@link OptionalOfOptionalRegular#optionalOfOptional() optionalOfOptional} attribute.
     * @param optionalOfOptional The value for optionalOfOptional 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> optionalOfOptional(Option<Optional<T>> optionalOfOptional) {
      this.optionalOfOptional = Objects.requireNonNull(optionalOfOptional, "optionalOfOptional");
      initBits &= ~INIT_BIT_OPTIONAL_OF_OPTIONAL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOptionalOfOptionalRegular ImmutableOptionalOfOptionalRegular}.
     * @return An immutable instance of OptionalOfOptionalRegular
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOptionalOfOptionalRegular<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOptionalOfOptionalRegular<>(optionalOfOptional);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_OPTIONAL_OF_OPTIONAL) != 0) attributes.add("optionalOfOptional");
      return "Cannot build OptionalOfOptionalRegular, some of required attributes are not set " + attributes;
    }
  }
}
