package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PrimitiveDefault}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePrimitiveDefault.builder()}.
 */
@Generated(from = "PrimitiveDefault", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePrimitiveDefault extends PrimitiveDefault {
  private final boolean def;

  private ImmutablePrimitiveDefault(ImmutablePrimitiveDefault.Builder builder) {
    this.def = builder.defIsSet()
        ? builder.def
        : super.def();
  }

  private ImmutablePrimitiveDefault(boolean def) {
    this.def = def;
  }

  /**
   * @return The value of the {@code def} attribute
   */
  @Override
  public boolean def() {
    return def;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrimitiveDefault#def() def} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for def
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrimitiveDefault withDef(boolean value) {
    if (this.def == value) return this;
    return new ImmutablePrimitiveDefault(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePrimitiveDefault} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePrimitiveDefault
        && equalTo(0, (ImmutablePrimitiveDefault) another);
  }

  private boolean equalTo(int synthetic, ImmutablePrimitiveDefault another) {
    return def == another.def;
  }

  /**
   * Computes a hash code from attributes: {@code def}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(def);
    return h;
  }

  /**
   * Prints the immutable value {@code PrimitiveDefault} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PrimitiveDefault")
        .omitNullValues()
        .add("def", def)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link PrimitiveDefault} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PrimitiveDefault instance
   */
  public static ImmutablePrimitiveDefault copyOf(PrimitiveDefault instance) {
    if (instance instanceof ImmutablePrimitiveDefault) {
      return (ImmutablePrimitiveDefault) instance;
    }
    return ImmutablePrimitiveDefault.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePrimitiveDefault ImmutablePrimitiveDefault}.
   * <pre>
   * ImmutablePrimitiveDefault.builder()
   *    .def(boolean) // optional {@link PrimitiveDefault#def() def}
   *    .build();
   * </pre>
   * @return A new ImmutablePrimitiveDefault builder
   */
  public static ImmutablePrimitiveDefault.Builder builder() {
    return new ImmutablePrimitiveDefault.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePrimitiveDefault ImmutablePrimitiveDefault}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PrimitiveDefault", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_DEF = 0x1L;
    private long optBits;

    private boolean def;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PrimitiveDefault} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PrimitiveDefault instance) {
      Objects.requireNonNull(instance, "instance");
      def(instance.def());
      return this;
    }

    /**
     * Initializes the value for the {@link PrimitiveDefault#def() def} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PrimitiveDefault#def() def}.</em>
     * @param def The value for def 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder def(boolean def) {
      this.def = def;
      optBits |= OPT_BIT_DEF;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePrimitiveDefault ImmutablePrimitiveDefault}.
     * @return An immutable instance of PrimitiveDefault
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePrimitiveDefault build() {
      return new ImmutablePrimitiveDefault(this);
    }

    private boolean defIsSet() {
      return (optBits & OPT_BIT_DEF) != 0;
    }
  }
}
