package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PrimitiveOptionals}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePrimitiveOptionals.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePrimitiveOptionals.of()}.
 */
@Generated(from = "PrimitiveOptionals", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePrimitiveOptionals implements PrimitiveOptionals {
  private final Optional<Integer> v1;
  private final Optional<Double> v2;
  private final @Nullable Integer v3;
  private final @Nullable Boolean v4;
  private final @Nullable String v5;
  private final Optional<String> v6;
  private final @Nullable Integer v7;
  private final @Nullable Double v8;
  private final @Nullable Long v9;

  private ImmutablePrimitiveOptionals(
      Optional<Integer> v1,
      Optional<Double> v2,
      java.util.Optional<Integer> v3) {
    this.v1 = v1;
    this.v2 = v2;
    this.v3 = v3.orElse(null);
    this.v4 = null;
    this.v5 = null;
    this.v6 = Optional.absent();
    this.v7 = null;
    this.v8 = null;
    this.v9 = null;
  }

  private ImmutablePrimitiveOptionals(
      Optional<Integer> v1,
      Optional<Double> v2,
      @Nullable Integer v3,
      @Nullable Boolean v4,
      @Nullable String v5,
      Optional<String> v6,
      @Nullable Integer v7,
      @Nullable Double v8,
      @Nullable Long v9) {
    this.v1 = v1;
    this.v2 = v2;
    this.v3 = v3;
    this.v4 = v4;
    this.v5 = v5;
    this.v6 = v6;
    this.v7 = v7;
    this.v8 = v8;
    this.v9 = v9;
  }

  /**
   * @return The value of the {@code v1} attribute
   */
  @Override
  public Optional<Integer> v1() {
    return v1;
  }

  /**
   * @return The value of the {@code v2} attribute
   */
  @Override
  public Optional<Double> v2() {
    return v2;
  }

  /**
   * @return The value of the {@code v3} attribute
   */
  @Override
  public java.util.Optional<Integer> v3() {
    return java.util.Optional.ofNullable(v3);
  }

  /**
   * @return The value of the {@code v4} attribute
   */
  @Override
  public java.util.Optional<Boolean> v4() {
    return java.util.Optional.ofNullable(v4);
  }

  /**
   * @return The value of the {@code v5} attribute
   */
  @Override
  public java.util.Optional<String> v5() {
    return java.util.Optional.ofNullable(v5);
  }

  /**
   * @return The value of the {@code v6} attribute
   */
  @Override
  public Optional<String> v6() {
    return v6;
  }

  /**
   * @return The value of the {@code v7} attribute
   */
  @Override
  public OptionalInt v7() {
    return v7 != null
        ? OptionalInt.of(v7)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code v8} attribute
   */
  @Override
  public OptionalDouble v8() {
    return v8 != null
        ? OptionalDouble.of(v8)
        : OptionalDouble.empty();
  }

  /**
   * @return The value of the {@code v9} attribute
   */
  @Override
  public OptionalLong v9() {
    return v9 != null
        ? OptionalLong.of(v9)
        : OptionalLong.empty();
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PrimitiveOptionals#v1() v1} attribute.
   * @param value The value for v1
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV1(int value) {
    Optional<Integer> newValue = Optional.of(value);
    if (this.v1.equals(newValue)) return this;
    return new ImmutablePrimitiveOptionals(newValue, this.v2, this.v3, this.v4, this.v5, this.v6, this.v7, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PrimitiveOptionals#v1() v1} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v1
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV1(Optional<Integer> optional) {
    Optional<Integer> value = optional;
    if (this.v1.equals(value)) return this;
    return new ImmutablePrimitiveOptionals(value, this.v2, this.v3, this.v4, this.v5, this.v6, this.v7, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PrimitiveOptionals#v2() v2} attribute.
   * @param value The value for v2
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV2(double value) {
    Optional<Double> newValue = Optional.of(value);
    if (this.v2.equals(newValue)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, newValue, this.v3, this.v4, this.v5, this.v6, this.v7, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PrimitiveOptionals#v2() v2} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v2
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV2(Optional<Double> optional) {
    Optional<Double> value = optional;
    if (this.v2.equals(value)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, value, this.v3, this.v4, this.v5, this.v6, this.v7, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PrimitiveOptionals#v3() v3} attribute.
   * @param value The value for v3
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV3(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.v3, newValue)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, newValue, this.v4, this.v5, this.v6, this.v7, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PrimitiveOptionals#v3() v3} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v3
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV3(java.util.Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.v3, value)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, value, this.v4, this.v5, this.v6, this.v7, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PrimitiveOptionals#v4() v4} attribute.
   * @param value The value for v4
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV4(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.v4, newValue)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, this.v3, newValue, this.v5, this.v6, this.v7, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PrimitiveOptionals#v4() v4} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v4
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV4(java.util.Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.v4, value)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, this.v3, value, this.v5, this.v6, this.v7, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PrimitiveOptionals#v5() v5} attribute.
   * @param value The value for v5
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV5(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "v5");
    if (Objects.equals(this.v5, newValue)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, this.v3, this.v4, newValue, this.v6, this.v7, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PrimitiveOptionals#v5() v5} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v5
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV5(java.util.Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.v5, value)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, this.v3, this.v4, value, this.v6, this.v7, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PrimitiveOptionals#v6() v6} attribute.
   * @param value The value for v6
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV6(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.v6.equals(newValue)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, this.v3, this.v4, this.v5, newValue, this.v7, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PrimitiveOptionals#v6() v6} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v6
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV6(Optional<String> optional) {
    Optional<String> value = optional;
    if (this.v6.equals(value)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, this.v3, this.v4, this.v5, value, this.v7, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PrimitiveOptionals#v7() v7} attribute.
   * @param value The value for v7
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV7(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.v7, newValue)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, this.v3, this.v4, this.v5, this.v6, newValue, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PrimitiveOptionals#v7() v7} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v7
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV7(OptionalInt optional) {
    @Nullable Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.v7, value)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, this.v3, this.v4, this.v5, this.v6, value, this.v8, this.v9);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PrimitiveOptionals#v8() v8} attribute.
   * @param value The value for v8
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV8(double value) {
    @Nullable Double newValue = value;
    if (Objects.equals(this.v8, newValue)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, this.v3, this.v4, this.v5, this.v6, this.v7, newValue, this.v9);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PrimitiveOptionals#v8() v8} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v8
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV8(OptionalDouble optional) {
    @Nullable Double value = optional.isPresent() ? optional.getAsDouble() : null;
    if (Objects.equals(this.v8, value)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, this.v3, this.v4, this.v5, this.v6, this.v7, value, this.v9);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PrimitiveOptionals#v9() v9} attribute.
   * @param value The value for v9
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV9(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.v9, newValue)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, this.v3, this.v4, this.v5, this.v6, this.v7, this.v8, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PrimitiveOptionals#v9() v9} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v9
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimitiveOptionals withV9(OptionalLong optional) {
    @Nullable Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.v9, value)) return this;
    return new ImmutablePrimitiveOptionals(this.v1, this.v2, this.v3, this.v4, this.v5, this.v6, this.v7, this.v8, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePrimitiveOptionals} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePrimitiveOptionals
        && equalTo(0, (ImmutablePrimitiveOptionals) another);
  }

  private boolean equalTo(int synthetic, ImmutablePrimitiveOptionals another) {
    return v1.equals(another.v1)
        && v2.equals(another.v2)
        && Objects.equals(v3, another.v3)
        && Objects.equals(v4, another.v4)
        && Objects.equals(v5, another.v5)
        && v6.equals(another.v6)
        && Objects.equals(v7, another.v7)
        && Objects.equals(v8, another.v8)
        && Objects.equals(v9, another.v9);
  }

  /**
   * Computes a hash code from attributes: {@code v1}, {@code v2}, {@code v3}, {@code v4}, {@code v5}, {@code v6}, {@code v7}, {@code v8}, {@code v9}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + v1.hashCode();
    h += (h << 5) + v2.hashCode();
    h += (h << 5) + Objects.hashCode(v3);
    h += (h << 5) + Objects.hashCode(v4);
    h += (h << 5) + Objects.hashCode(v5);
    h += (h << 5) + v6.hashCode();
    h += (h << 5) + Objects.hashCode(v7);
    h += (h << 5) + Objects.hashCode(v8);
    h += (h << 5) + Objects.hashCode(v9);
    return h;
  }

  /**
   * Prints the immutable value {@code PrimitiveOptionals} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PrimitiveOptionals")
        .omitNullValues()
        .add("v1", v1.orNull())
        .add("v2", v2.orNull())
        .add("v3", v3)
        .add("v4", v4)
        .add("v5", v5)
        .add("v6", v6.orNull())
        .add("v7", v7)
        .add("v8", v8)
        .add("v9", v9)
        .toString();
  }

  /**
   * Construct a new immutable {@code PrimitiveOptionals} instance.
   * @param v1 The value for the {@code v1} attribute
   * @param v2 The value for the {@code v2} attribute
   * @param v3 The value for the {@code v3} attribute
   * @return An immutable PrimitiveOptionals instance
   */
  public static ImmutablePrimitiveOptionals of(Optional<Integer> v1, Optional<Double> v2, java.util.Optional<Integer> v3) {
    return new ImmutablePrimitiveOptionals(v1, v2, v3);
  }

  /**
   * Creates an immutable copy of a {@link PrimitiveOptionals} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PrimitiveOptionals instance
   */
  public static ImmutablePrimitiveOptionals copyOf(PrimitiveOptionals instance) {
    if (instance instanceof ImmutablePrimitiveOptionals) {
      return (ImmutablePrimitiveOptionals) instance;
    }
    return ImmutablePrimitiveOptionals.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePrimitiveOptionals ImmutablePrimitiveOptionals}.
   * <pre>
   * ImmutablePrimitiveOptionals.builder()
   *    .v1(Integer) // optional {@link PrimitiveOptionals#v1() v1}
   *    .v2(Double) // optional {@link PrimitiveOptionals#v2() v2}
   *    .v3(Integer) // optional {@link PrimitiveOptionals#v3() v3}
   *    .v4(Boolean) // optional {@link PrimitiveOptionals#v4() v4}
   *    .v5(String) // optional {@link PrimitiveOptionals#v5() v5}
   *    .v6(String) // optional {@link PrimitiveOptionals#v6() v6}
   *    .v7(int) // optional {@link PrimitiveOptionals#v7() v7}
   *    .v8(double) // optional {@link PrimitiveOptionals#v8() v8}
   *    .v9(long) // optional {@link PrimitiveOptionals#v9() v9}
   *    .build();
   * </pre>
   * @return A new ImmutablePrimitiveOptionals builder
   */
  public static ImmutablePrimitiveOptionals.Builder builder() {
    return new ImmutablePrimitiveOptionals.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePrimitiveOptionals ImmutablePrimitiveOptionals}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PrimitiveOptionals", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Optional<Integer> v1 = Optional.absent();
    private Optional<Double> v2 = Optional.absent();
    private @Nullable Integer v3;
    private @Nullable Boolean v4;
    private @Nullable String v5;
    private Optional<String> v6 = Optional.absent();
    private @Nullable Integer v7;
    private @Nullable Double v8;
    private @Nullable Long v9;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PrimitiveOptionals} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PrimitiveOptionals instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<Integer> v1Optional = instance.v1();
      if (v1Optional.isPresent()) {
        v1(v1Optional);
      }
      Optional<Double> v2Optional = instance.v2();
      if (v2Optional.isPresent()) {
        v2(v2Optional);
      }
      java.util.Optional<Integer> v3Optional = instance.v3();
      if (v3Optional.isPresent()) {
        v3(v3Optional);
      }
      java.util.Optional<Boolean> v4Optional = instance.v4();
      if (v4Optional.isPresent()) {
        v4(v4Optional);
      }
      java.util.Optional<String> v5Optional = instance.v5();
      if (v5Optional.isPresent()) {
        v5(v5Optional);
      }
      Optional<String> v6Optional = instance.v6();
      if (v6Optional.isPresent()) {
        v6(v6Optional);
      }
      OptionalInt v7Optional = instance.v7();
      if (v7Optional.isPresent()) {
        v7(v7Optional);
      }
      OptionalDouble v8Optional = instance.v8();
      if (v8Optional.isPresent()) {
        v8(v8Optional);
      }
      OptionalLong v9Optional = instance.v9();
      if (v9Optional.isPresent()) {
        v9(v9Optional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v1() v1} to v1.
     * @param v1 The value for v1
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v1(int v1) {
      this.v1 = Optional.of(v1);
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v1() v1} to v1.
     * @param v1 The value for v1
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v1(Optional<Integer> v1) {
      this.v1 = v1;
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v2() v2} to v2.
     * @param v2 The value for v2
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v2(double v2) {
      this.v2 = Optional.of(v2);
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v2() v2} to v2.
     * @param v2 The value for v2
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v2(Optional<Double> v2) {
      this.v2 = v2;
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v3() v3} to v3.
     * @param v3 The value for v3
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v3(int v3) {
      this.v3 = v3;
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v3() v3} to v3.
     * @param v3 The value for v3
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v3(java.util.Optional<Integer> v3) {
      this.v3 = v3.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v4() v4} to v4.
     * @param v4 The value for v4
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v4(boolean v4) {
      this.v4 = v4;
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v4() v4} to v4.
     * @param v4 The value for v4
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v4(java.util.Optional<Boolean> v4) {
      this.v4 = v4.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v5() v5} to v5.
     * @param v5 The value for v5
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v5(String v5) {
      this.v5 = Objects.requireNonNull(v5, "v5");
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v5() v5} to v5.
     * @param v5 The value for v5
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v5(java.util.Optional<String> v5) {
      this.v5 = v5.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v6() v6} to v6.
     * @param v6 The value for v6
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v6(String v6) {
      this.v6 = Optional.of(v6);
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v6() v6} to v6.
     * @param v6 The value for v6
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v6(Optional<String> v6) {
      this.v6 = v6;
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v7() v7} to v7.
     * @param v7 The value for v7
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v7(int v7) {
      this.v7 = v7;
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v7() v7} to v7.
     * @param v7 The value for v7
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v7(OptionalInt v7) {
      this.v7 = v7.isPresent() ? v7.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v8() v8} to v8.
     * @param v8 The value for v8
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v8(double v8) {
      this.v8 = v8;
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v8() v8} to v8.
     * @param v8 The value for v8
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v8(OptionalDouble v8) {
      this.v8 = v8.isPresent() ? v8.getAsDouble() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v9() v9} to v9.
     * @param v9 The value for v9
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v9(long v9) {
      this.v9 = v9;
      return this;
    }

    /**
     * Initializes the optional value {@link PrimitiveOptionals#v9() v9} to v9.
     * @param v9 The value for v9
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v9(OptionalLong v9) {
      this.v9 = v9.isPresent() ? v9.getAsLong() : null;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePrimitiveOptionals ImmutablePrimitiveOptionals}.
     * @return An immutable instance of PrimitiveOptionals
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePrimitiveOptionals build() {
      return new ImmutablePrimitiveOptionals(v1, v2, v3, v4, v5, v6, v7, v8, v9);
    }
  }
}
