package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Redacted}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRedacted.builder()}.
 */
@Generated(from = "Redacted", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRedacted implements Redacted {
  private final long id;
  private final int code;
  private final String ssn;
  private final String[] data;

  private ImmutableRedacted(long id, int code, String ssn, String[] data) {
    this.id = id;
    this.code = code;
    this.ssn = ssn;
    this.data = data;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public long id() {
    return id;
  }

  /**
   * @return The value of the {@code code} attribute
   */
  @Override
  public int code() {
    return code;
  }

  /**
   * @return The value of the {@code ssn} attribute
   */
  @Override
  public String ssn() {
    return ssn;
  }

  /**
   * @return A cloned {@code data} array
   */
  @Override
  public String[] data() {
    return data.clone();
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Redacted#id() id} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRedacted withId(long value) {
    if (this.id == value) return this;
    return new ImmutableRedacted(value, this.code, this.ssn, this.data);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Redacted#code() code} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for code
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRedacted withCode(int value) {
    if (this.code == value) return this;
    return new ImmutableRedacted(this.id, value, this.ssn, this.data);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Redacted#ssn() ssn} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ssn
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRedacted withSsn(String value) {
    String newValue = Objects.requireNonNull(value, "ssn");
    if (this.ssn.equals(newValue)) return this;
    return new ImmutableRedacted(this.id, this.code, newValue, this.data);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Redacted#data() data}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for data
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRedacted withData(String... elements) {
    String[] newValue = elements.clone();
    return new ImmutableRedacted(this.id, this.code, this.ssn, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRedacted} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRedacted
        && equalTo(0, (ImmutableRedacted) another);
  }

  private boolean equalTo(int synthetic, ImmutableRedacted another) {
    return id == another.id
        && code == another.code
        && ssn.equals(another.ssn)
        && Arrays.equals(data, another.data);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code code}, {@code ssn}, {@code data}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Longs.hashCode(id);
    h += (h << 5) + code;
    h += (h << 5) + ssn.hashCode();
    h += (h << 5) + Arrays.hashCode(data);
    return h;
  }

  /**
   * Prints the immutable value {@code Redacted} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Redacted")
        .omitNullValues()
        .add("id", id)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Redacted} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Redacted instance
   */
  public static ImmutableRedacted copyOf(Redacted instance) {
    if (instance instanceof ImmutableRedacted) {
      return (ImmutableRedacted) instance;
    }
    return ImmutableRedacted.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRedacted ImmutableRedacted}.
   * <pre>
   * ImmutableRedacted.builder()
   *    .id(long) // required {@link Redacted#id() id}
   *    .code(int) // required {@link Redacted#code() code}
   *    .ssn(String) // required {@link Redacted#ssn() ssn}
   *    .data(String) // required {@link Redacted#data() data}
   *    .build();
   * </pre>
   * @return A new ImmutableRedacted builder
   */
  public static ImmutableRedacted.Builder builder() {
    return new ImmutableRedacted.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRedacted ImmutableRedacted}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Redacted", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_CODE = 0x2L;
    private static final long INIT_BIT_SSN = 0x4L;
    private static final long INIT_BIT_DATA = 0x8L;
    private long initBits = 0xfL;

    private long id;
    private int code;
    private @Nullable String ssn;
    private @Nullable String[] data;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Redacted} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Redacted instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      code(instance.code());
      ssn(instance.ssn());
      data(instance.data());
      return this;
    }

    /**
     * Initializes the value for the {@link Redacted#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(long id) {
      this.id = id;
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Redacted#code() code} attribute.
     * @param code The value for code 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder code(int code) {
      this.code = code;
      initBits &= ~INIT_BIT_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link Redacted#ssn() ssn} attribute.
     * @param ssn The value for ssn 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ssn(String ssn) {
      this.ssn = Objects.requireNonNull(ssn, "ssn");
      initBits &= ~INIT_BIT_SSN;
      return this;
    }

    /**
     * Initializes the value for the {@link Redacted#data() data} attribute.
     * @param data The elements for data
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder data(String... data) {
      this.data = data.clone();
      initBits &= ~INIT_BIT_DATA;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRedacted ImmutableRedacted}.
     * @return An immutable instance of Redacted
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRedacted build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRedacted(id, code, ssn, data);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_CODE) != 0) attributes.add("code");
      if ((initBits & INIT_BIT_SSN) != 0) attributes.add("ssn");
      if ((initBits & INIT_BIT_DATA) != 0) attributes.add("data");
      return "Cannot build Redacted, some of required attributes are not set " + attributes;
    }
  }
}
