package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SafeDerivedInit.SafeInitAclass}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSafeInitAclass.builder()}.
 */
@Generated(from = "SafeDerivedInit.SafeInitAclass", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSafeInitAclass extends SafeDerivedInit.SafeInitAclass {
  private final int a;
  private final int b;
  private final int c;

  private ImmutableSafeInitAclass(ImmutableSafeInitAclass.Builder builder) {
    this.a = builder.aIsSet()
        ? builder.a
        : super.a();
    this.b = builder.bIsSet()
        ? builder.b
        : super.b();
    this.c = builder.cIsSet()
        ? builder.c
        : super.c();
  }

  private ImmutableSafeInitAclass(int a, int b, int c) {
    this.a = a;
    this.b = b;
    this.c = c;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  int b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  int c() {
    return c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SafeDerivedInit.SafeInitAclass#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSafeInitAclass withA(int value) {
    if (this.a == value) return this;
    return new ImmutableSafeInitAclass(value, this.b, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SafeDerivedInit.SafeInitAclass#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSafeInitAclass withB(int value) {
    if (this.b == value) return this;
    return new ImmutableSafeInitAclass(this.a, value, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SafeDerivedInit.SafeInitAclass#c() c} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSafeInitAclass withC(int value) {
    if (this.c == value) return this;
    return new ImmutableSafeInitAclass(this.a, this.b, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSafeInitAclass} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSafeInitAclass
        && equalTo(0, (ImmutableSafeInitAclass) another);
  }

  private boolean equalTo(int synthetic, ImmutableSafeInitAclass another) {
    return a == another.a
        && b == another.b
        && c == another.c;
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b;
    h += (h << 5) + c;
    return h;
  }

  /**
   * Prints the immutable value {@code SafeInitAclass} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SafeInitAclass")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SafeDerivedInit.SafeInitAclass} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SafeInitAclass instance
   */
  public static ImmutableSafeInitAclass copyOf(SafeDerivedInit.SafeInitAclass instance) {
    if (instance instanceof ImmutableSafeInitAclass) {
      return (ImmutableSafeInitAclass) instance;
    }
    return ImmutableSafeInitAclass.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSafeInitAclass ImmutableSafeInitAclass}.
   * <pre>
   * ImmutableSafeInitAclass.builder()
   *    .a(int) // optional {@link SafeDerivedInit.SafeInitAclass#a() a}
   *    .b(int) // optional {@link SafeDerivedInit.SafeInitAclass#b() b}
   *    .c(int) // optional {@link SafeDerivedInit.SafeInitAclass#c() c}
   *    .build();
   * </pre>
   * @return A new ImmutableSafeInitAclass builder
   */
  public static ImmutableSafeInitAclass.Builder builder() {
    return new ImmutableSafeInitAclass.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSafeInitAclass ImmutableSafeInitAclass}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SafeDerivedInit.SafeInitAclass", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_A = 0x1L;
    private static final long OPT_BIT_B = 0x2L;
    private static final long OPT_BIT_C = 0x4L;
    private long optBits;

    private int a;
    private int b;
    private int c;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SafeInitAclass} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SafeDerivedInit.SafeInitAclass instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      c(instance.c());
      return this;
    }

    /**
     * Initializes the value for the {@link SafeDerivedInit.SafeInitAclass#a() a} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SafeDerivedInit.SafeInitAclass#a() a}.</em>
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      optBits |= OPT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link SafeDerivedInit.SafeInitAclass#b() b} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SafeDerivedInit.SafeInitAclass#b() b}.</em>
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(int b) {
      this.b = b;
      optBits |= OPT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link SafeDerivedInit.SafeInitAclass#c() c} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SafeDerivedInit.SafeInitAclass#c() c}.</em>
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(int c) {
      this.c = c;
      optBits |= OPT_BIT_C;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSafeInitAclass ImmutableSafeInitAclass}.
     * @return An immutable instance of SafeInitAclass
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSafeInitAclass build() {
      return new ImmutableSafeInitAclass(this);
    }

    private boolean aIsSet() {
      return (optBits & OPT_BIT_A) != 0;
    }

    private boolean bIsSet() {
      return (optBits & OPT_BIT_B) != 0;
    }

    private boolean cIsSet() {
      return (optBits & OPT_BIT_C) != 0;
    }
  }
}
