package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableSampleNesting} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link SampleNesting}.
 * @see ImmutableSampleNesting.A
 * @see ImmutableSampleNesting.B
 */
@Generated(from = "SampleNesting", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableSampleNesting {
  private ImmutableSampleNesting() {}

  /**
   * Immutable implementation of {@link SampleNesting.A}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableSampleNesting.A.builder()}.
   */
  @Generated(from = "SampleNesting.A", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class A implements SampleNesting.A {

    private A(ImmutableSampleNesting.A.Builder builder) {
    }

    /**
     * This instance is equal to all instances of {@code A} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableSampleNesting.A
          && equalTo(0, (ImmutableSampleNesting.A) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(int synthetic, ImmutableSampleNesting.A another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 655875322;
    }

    /**
     * Prints the immutable value {@code A}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "A{}";
    }

    /**
     * Creates an immutable copy of a {@link SampleNesting.A} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable A instance
     */
    public static ImmutableSampleNesting.A copyOf(SampleNesting.A instance) {
      if (instance instanceof ImmutableSampleNesting.A) {
        return (ImmutableSampleNesting.A) instance;
      }
      return ImmutableSampleNesting.A.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableSampleNesting.A A}.
     * <pre>
     * ImmutableSampleNesting.A.builder()
     *    .build();
     * </pre>
     * @return A new A builder
     */
    public static ImmutableSampleNesting.A.Builder builder() {
      return new ImmutableSampleNesting.A.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableSampleNesting.A A}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "SampleNesting.A", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code A} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(SampleNesting.A instance) {
        Objects.requireNonNull(instance, "instance");
        return this;
      }

      /**
       * Builds a new {@link ImmutableSampleNesting.A A}.
       * @return An immutable instance of A
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableSampleNesting.A build() {
        return new ImmutableSampleNesting.A(this);
      }
    }
  }

  /**
   * Immutable implementation of {@link SampleNesting.B}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableSampleNesting.B.builder()}.
   */
  @Generated(from = "SampleNesting.B", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class B extends SampleNesting.B {

    private B(ImmutableSampleNesting.B.Builder builder) {
    }

    /**
     * This instance is equal to all instances of {@code B} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableSampleNesting.B
          && equalTo(0, (ImmutableSampleNesting.B) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(int synthetic, ImmutableSampleNesting.B another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 655875323;
    }

    /**
     * Prints the immutable value {@code B}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "B{}";
    }

    /**
     * Creates an immutable copy of a {@link SampleNesting.B} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable B instance
     */
    public static ImmutableSampleNesting.B copyOf(SampleNesting.B instance) {
      if (instance instanceof ImmutableSampleNesting.B) {
        return (ImmutableSampleNesting.B) instance;
      }
      return ImmutableSampleNesting.B.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableSampleNesting.B B}.
     * <pre>
     * ImmutableSampleNesting.B.builder()
     *    .build();
     * </pre>
     * @return A new B builder
     */
    public static ImmutableSampleNesting.B.Builder builder() {
      return new ImmutableSampleNesting.B.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableSampleNesting.B B}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "SampleNesting.B", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code B} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(SampleNesting.B instance) {
        Objects.requireNonNull(instance, "instance");
        return this;
      }

      /**
       * Builds a new {@link ImmutableSampleNesting.B B}.
       * @return An immutable instance of B
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableSampleNesting.B build() {
        return new ImmutableSampleNesting.B(this);
      }
    }
  }
}
