package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SampleValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSampleValue.builder()}.
 */
@Generated(from = "SampleValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSampleValue implements SampleValue {
  private final int a;
  private final ImmutableList<Integer> c;
  private final @Nullable Integer oi;
  private final Optional<String> os;

  private ImmutableSampleValue(
      int a,
      ImmutableList<Integer> c,
      @Nullable Integer oi,
      Optional<String> os) {
    this.a = a;
    this.c = c;
    this.oi = oi;
    this.os = os;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public ImmutableList<Integer> c() {
    return c;
  }

  /**
   * @return The value of the {@code oi} attribute
   */
  @Override
  public OptionalInt oi() {
    return oi != null
        ? OptionalInt.of(oi)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code os} attribute
   */
  @Override
  public Optional<String> os() {
    return os;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SampleValue#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSampleValue withA(int value) {
    if (this.a == value) return this;
    return new ImmutableSampleValue(value, this.c, this.oi, this.os);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SampleValue#c() c}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSampleValue withC(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableSampleValue(this.a, newValue, this.oi, this.os);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SampleValue#c() c}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of c elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSampleValue withC(Iterable<Integer> elements) {
    if (this.c == elements) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSampleValue(this.a, newValue, this.oi, this.os);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SampleValue#oi() oi} attribute.
   * @param value The value for oi
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSampleValue withOi(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.oi, newValue)) return this;
    return new ImmutableSampleValue(this.a, this.c, newValue, this.os);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SampleValue#oi() oi} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for oi
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSampleValue withOi(OptionalInt optional) {
    @Nullable Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.oi, value)) return this;
    return new ImmutableSampleValue(this.a, this.c, value, this.os);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SampleValue#os() os} attribute.
   * @param value The value for os
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSampleValue withOs(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.os.equals(newValue)) return this;
    return new ImmutableSampleValue(this.a, this.c, this.oi, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SampleValue#os() os} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for os
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSampleValue withOs(Optional<String> optional) {
    Optional<String> value = optional;
    if (this.os.equals(value)) return this;
    return new ImmutableSampleValue(this.a, this.c, this.oi, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSampleValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSampleValue
        && equalTo(0, (ImmutableSampleValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableSampleValue another) {
    return a == another.a
        && c.equals(another.c)
        && Objects.equals(oi, another.oi)
        && os.equals(another.os);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code c}, {@code oi}, {@code os}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + c.hashCode();
    h += (h << 5) + Objects.hashCode(oi);
    h += (h << 5) + os.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SampleValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SampleValue")
        .omitNullValues()
        .add("a", a)
        .add("c", c)
        .add("oi", oi)
        .add("os", os.orNull())
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SampleValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SampleValue instance
   */
  public static ImmutableSampleValue copyOf(SampleValue instance) {
    if (instance instanceof ImmutableSampleValue) {
      return (ImmutableSampleValue) instance;
    }
    return ImmutableSampleValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSampleValue ImmutableSampleValue}.
   * <pre>
   * ImmutableSampleValue.builder()
   *    .a(int) // required {@link SampleValue#a() a}
   *    .addC|addAllC(int) // {@link SampleValue#c() c} elements
   *    .oi(int) // optional {@link SampleValue#oi() oi}
   *    .os(String) // optional {@link SampleValue#os() os}
   *    .build();
   * </pre>
   * @return A new ImmutableSampleValue builder
   */
  public static ImmutableSampleValue.Builder builder() {
    return new ImmutableSampleValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSampleValue ImmutableSampleValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SampleValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private int a;
    private ImmutableList.Builder<Integer> c = ImmutableList.builder();
    private @Nullable Integer oi;
    private Optional<String> os = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SampleValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SampleValue instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      addAllC(instance.c());
      OptionalInt oiOptional = instance.oi();
      if (oiOptional.isPresent()) {
        oi(oiOptional);
      }
      Optional<String> osOptional = instance.os();
      if (osOptional.isPresent()) {
        os(osOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SampleValue#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Adds one element to {@link SampleValue#c() c} list.
     * @param element A c element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addC(int element) {
      this.c.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SampleValue#c() c} list.
     * @param elements An array of c elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addC(int... elements) {
      this.c.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SampleValue#c() c} list.
     * @param elements An iterable of c elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(Iterable<Integer> elements) {
      this.c = ImmutableList.builder();
      return addAllC(elements);
    }

    /**
     * Adds elements to {@link SampleValue#c() c} list.
     * @param elements An iterable of c elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllC(Iterable<Integer> elements) {
      this.c.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link SampleValue#oi() oi} to oi.
     * @param oi The value for oi
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder oi(int oi) {
      this.oi = oi;
      return this;
    }

    /**
     * Initializes the optional value {@link SampleValue#oi() oi} to oi.
     * @param oi The value for oi
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder oi(OptionalInt oi) {
      this.oi = oi.isPresent() ? oi.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link SampleValue#os() os} to os.
     * @param os The value for os
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder os(String os) {
      this.os = Optional.of(os);
      return this;
    }

    /**
     * Initializes the optional value {@link SampleValue#os() os} to os.
     * @param os The value for os
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder os(Optional<String> os) {
      this.os = os;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSampleValue ImmutableSampleValue}.
     * @return An immutable instance of SampleValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSampleValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSampleValue(a, c.build(), oi, os);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build SampleValue, some of required attributes are not set " + attributes;
    }
  }
}
