package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillyIntWrap}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSillyIntWrap.of()}.
 */
@Generated(from = "SillyIntWrap", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillyIntWrap extends SillyIntWrap {
  private final int value;

  private ImmutableSillyIntWrap(int value) {
    this.value = value;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public int value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyIntWrap#value() value} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyIntWrap withValue(int value) {
    if (this.value == value) return this;
    return new ImmutableSillyIntWrap(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillyIntWrap} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillyIntWrap
        && equalTo(0, (ImmutableSillyIntWrap) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillyIntWrap another) {
    return value == another.value;
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value;
    return h;
  }

  /**
   * Prints the immutable value {@code SillyIntWrap} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillyIntWrap")
        .omitNullValues()
        .add("value", value)
        .toString();
  }

  /**
   * Construct a new immutable {@code SillyIntWrap} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable SillyIntWrap instance
   */
  public static ImmutableSillyIntWrap of(int value) {
    return new ImmutableSillyIntWrap(value);
  }

  /**
   * Creates an immutable copy of a {@link SillyIntWrap} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillyIntWrap instance
   */
  public static ImmutableSillyIntWrap copyOf(SillyIntWrap instance) {
    if (instance instanceof ImmutableSillyIntWrap) {
      return (ImmutableSillyIntWrap) instance;
    }
    return ImmutableSillyIntWrap.of(instance.value());
  }
}
