package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillyMapHolder}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSillyMapHolder.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSillyMapHolder.of()}.
 */
@Generated(from = "SillyMapHolder", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillyMapHolder extends SillyMapHolder {
  private final ImmutableMap<SillyValue, Integer> holder1;
  private final ImmutableMap<Integer, String> holder2;
  private final ImmutableMap<String, SillyMapTup> holder3;
  private final ImmutableSet<RetentionPolicy> zz;

  private ImmutableSillyMapHolder(
      Map<SillyValue, ? extends Integer> holder1,
      Map<Integer, ? extends String> holder2) {
    this.holder1 = Maps.immutableEnumMap(holder1);
    this.holder2 = ImmutableMap.copyOf(holder2);
    this.holder3 = ImmutableMap.of();
    this.zz = ImmutableSet.of();
  }

  private ImmutableSillyMapHolder(
      ImmutableMap<SillyValue, Integer> holder1,
      ImmutableMap<Integer, String> holder2,
      ImmutableMap<String, SillyMapTup> holder3,
      ImmutableSet<RetentionPolicy> zz) {
    this.holder1 = holder1;
    this.holder2 = holder2;
    this.holder3 = holder3;
    this.zz = zz;
  }

  /**
   * @return The value of the {@code holder1} attribute
   */
  @Override
  public ImmutableMap<SillyValue, Integer> holder1() {
    return holder1;
  }

  /**
   * @return The value of the {@code holder2} attribute
   */
  @Override
  public ImmutableMap<Integer, String> holder2() {
    return holder2;
  }

  /**
   * @return The value of the {@code holder3} attribute
   */
  @Override
  public ImmutableMap<String, SillyMapTup> holder3() {
    return holder3;
  }

  /**
   * @return The value of the {@code zz} attribute
   */
  @Override
  public ImmutableSet<RetentionPolicy> zz() {
    return zz;
  }

  /**
   * Copy the current immutable object by replacing the {@link SillyMapHolder#holder1() holder1} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the holder1 map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyMapHolder withHolder1(Map<SillyValue, ? extends Integer> entries) {
    if (this.holder1 == entries) return this;
    ImmutableMap<SillyValue, Integer> newValue = Maps.immutableEnumMap(entries);
    return new ImmutableSillyMapHolder(newValue, this.holder2, this.holder3, this.zz);
  }

  /**
   * Copy the current immutable object by replacing the {@link SillyMapHolder#holder2() holder2} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the holder2 map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyMapHolder withHolder2(Map<Integer, ? extends String> entries) {
    if (this.holder2 == entries) return this;
    ImmutableMap<Integer, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableSillyMapHolder(this.holder1, newValue, this.holder3, this.zz);
  }

  /**
   * Copy the current immutable object by replacing the {@link SillyMapHolder#holder3() holder3} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the holder3 map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyMapHolder withHolder3(Map<String, ? extends SillyMapTup> entries) {
    if (this.holder3 == entries) return this;
    ImmutableMap<String, SillyMapTup> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableSillyMapHolder(this.holder1, this.holder2, newValue, this.zz);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillyMapHolder#zz() zz}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyMapHolder withZz(RetentionPolicy... elements) {
    ImmutableSet<RetentionPolicy> newValue = Sets.immutableEnumSet(Arrays.asList(elements));
    return new ImmutableSillyMapHolder(this.holder1, this.holder2, this.holder3, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillyMapHolder#zz() zz}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of zz elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyMapHolder withZz(Iterable<RetentionPolicy> elements) {
    if (this.zz == elements) return this;
    ImmutableSet<RetentionPolicy> newValue = Sets.immutableEnumSet(elements);
    return new ImmutableSillyMapHolder(this.holder1, this.holder2, this.holder3, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillyMapHolder} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillyMapHolder
        && equalTo(0, (ImmutableSillyMapHolder) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillyMapHolder another) {
    return holder1.equals(another.holder1)
        && holder2.equals(another.holder2)
        && holder3.equals(another.holder3)
        && zz.equals(another.zz);
  }

  /**
   * Computes a hash code from attributes: {@code holder1}, {@code holder2}, {@code holder3}, {@code zz}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + holder1.hashCode();
    h += (h << 5) + holder2.hashCode();
    h += (h << 5) + holder3.hashCode();
    h += (h << 5) + zz.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SillyMapHolder} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillyMapHolder")
        .omitNullValues()
        .add("holder1", holder1)
        .add("holder2", holder2)
        .add("holder3", holder3)
        .add("zz", zz)
        .toString();
  }

  /**
   * Construct a new immutable {@code SillyMapHolder} instance.
   * @param holder1 The value for the {@code holder1} attribute
   * @param holder2 The value for the {@code holder2} attribute
   * @return An immutable SillyMapHolder instance
   */
  public static ImmutableSillyMapHolder of(Map<SillyValue, ? extends Integer> holder1, Map<Integer, ? extends String> holder2) {
    return new ImmutableSillyMapHolder(holder1, holder2);
  }

  /**
   * Creates an immutable copy of a {@link SillyMapHolder} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillyMapHolder instance
   */
  public static ImmutableSillyMapHolder copyOf(SillyMapHolder instance) {
    if (instance instanceof ImmutableSillyMapHolder) {
      return (ImmutableSillyMapHolder) instance;
    }
    return ImmutableSillyMapHolder.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSillyMapHolder ImmutableSillyMapHolder}.
   * <pre>
   * ImmutableSillyMapHolder.builder()
   *    .putHolder1|putAllHolder1(org.immutables.fixture.SillyValue =&gt; int) // {@link SillyMapHolder#holder1() holder1} mappings
   *    .putHolder2|putAllHolder2(int =&gt; String) // {@link SillyMapHolder#holder2() holder2} mappings
   *    .putHolder3|putAllHolder3(String =&gt; org.immutables.fixture.SillyMapTup) // {@link SillyMapHolder#holder3() holder3} mappings
   *    .addZz|addAllZz(annotation.RetentionPolicy) // {@link SillyMapHolder#zz() zz} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSillyMapHolder builder
   */
  public static ImmutableSillyMapHolder.Builder builder() {
    return new ImmutableSillyMapHolder.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSillyMapHolder ImmutableSillyMapHolder}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SillyMapHolder", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableMap.Builder<SillyValue, Integer> holder1 = ImmutableMap.builder();
    private ImmutableMap.Builder<Integer, String> holder2 = ImmutableMap.builder();
    private ImmutableMap.Builder<String, SillyMapTup> holder3 = ImmutableMap.builder();
    private ImmutableSet.Builder<RetentionPolicy> zz = ImmutableSet.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SillyMapHolder} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SillyMapHolder instance) {
      Objects.requireNonNull(instance, "instance");
      putAllHolder1(instance.holder1());
      putAllHolder2(instance.holder2());
      putAllHolder3(instance.holder3());
      addAllZz(instance.zz());
      return this;
    }

    /**
     * Put one entry to the {@link SillyMapHolder#holder1() holder1} map.
     * @param key The key in the holder1 map
     * @param value The associated value in the holder1 map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHolder1(SillyValue key, int value) {
      this.holder1.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link SillyMapHolder#holder1() holder1} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHolder1(Map.Entry<SillyValue, ? extends Integer> entry) {
      this.holder1.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link SillyMapHolder#holder1() holder1} map. Nulls are not permitted
     * @param entries The entries that will be added to the holder1 map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder holder1(Map<SillyValue, ? extends Integer> entries) {
      this.holder1 = ImmutableMap.builder();
      return putAllHolder1(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link SillyMapHolder#holder1() holder1} map. Nulls are not permitted
     * @param entries The entries that will be added to the holder1 map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllHolder1(Map<SillyValue, ? extends Integer> entries) {
      this.holder1.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link SillyMapHolder#holder2() holder2} map.
     * @param key The key in the holder2 map
     * @param value The associated value in the holder2 map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHolder2(int key, String value) {
      this.holder2.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link SillyMapHolder#holder2() holder2} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHolder2(Map.Entry<Integer, ? extends String> entry) {
      this.holder2.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link SillyMapHolder#holder2() holder2} map. Nulls are not permitted
     * @param entries The entries that will be added to the holder2 map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder holder2(Map<Integer, ? extends String> entries) {
      this.holder2 = ImmutableMap.builder();
      return putAllHolder2(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link SillyMapHolder#holder2() holder2} map. Nulls are not permitted
     * @param entries The entries that will be added to the holder2 map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllHolder2(Map<Integer, ? extends String> entries) {
      this.holder2.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link SillyMapHolder#holder3() holder3} map.
     * @param key The key in the holder3 map
     * @param value The associated value in the holder3 map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHolder3(String key, SillyMapTup value) {
      this.holder3.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link SillyMapHolder#holder3() holder3} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHolder3(Map.Entry<String, ? extends SillyMapTup> entry) {
      this.holder3.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link SillyMapHolder#holder3() holder3} map. Nulls are not permitted
     * @param entries The entries that will be added to the holder3 map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder holder3(Map<String, ? extends SillyMapTup> entries) {
      this.holder3 = ImmutableMap.builder();
      return putAllHolder3(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link SillyMapHolder#holder3() holder3} map. Nulls are not permitted
     * @param entries The entries that will be added to the holder3 map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllHolder3(Map<String, ? extends SillyMapTup> entries) {
      this.holder3.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link SillyMapHolder#zz() zz} set.
     * @param element A zz element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addZz(RetentionPolicy element) {
      this.zz.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SillyMapHolder#zz() zz} set.
     * @param elements An array of zz elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addZz(RetentionPolicy... elements) {
      this.zz.addAll(Arrays.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SillyMapHolder#zz() zz} set.
     * @param elements An iterable of zz elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder zz(Iterable<RetentionPolicy> elements) {
      this.zz = ImmutableSet.builder();
      return addAllZz(elements);
    }

    /**
     * Adds elements to {@link SillyMapHolder#zz() zz} set.
     * @param elements An iterable of zz elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllZz(Iterable<RetentionPolicy> elements) {
      this.zz.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSillyMapHolder ImmutableSillyMapHolder}.
     * @return An immutable instance of SillyMapHolder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSillyMapHolder build() {
      return new ImmutableSillyMapHolder(
          Maps.immutableEnumMap(holder1.build()),
          holder2.build(),
          holder3.build(),
          Sets.immutableEnumSet(zz.build()));
    }
  }
}
