package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillySub2}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSillySub2.builder()}.
 */
@Generated(from = "SillySub2", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillySub2 extends SillySub2 {
  private final String b;

  private ImmutableSillySub2(String b) {
    this.b = b;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public String b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillySub2#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillySub2 withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableSillySub2(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillySub2} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillySub2
        && equalTo(0, (ImmutableSillySub2) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillySub2 another) {
    return b.equals(another.b);
  }

  /**
   * Computes a hash code from attributes: {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + b.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SillySub2} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillySub2")
        .omitNullValues()
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SillySub2} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillySub2 instance
   */
  public static ImmutableSillySub2 copyOf(SillySub2 instance) {
    if (instance instanceof ImmutableSillySub2) {
      return (ImmutableSillySub2) instance;
    }
    return ImmutableSillySub2.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSillySub2 ImmutableSillySub2}.
   * <pre>
   * ImmutableSillySub2.builder()
   *    .b(String) // required {@link SillySub2#b() b}
   *    .build();
   * </pre>
   * @return A new ImmutableSillySub2 builder
   */
  public static ImmutableSillySub2.Builder builder() {
    return new ImmutableSillySub2.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSillySub2 ImmutableSillySub2}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SillySub2", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_B = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String b;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SillySub2} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SillySub2 instance) {
      Objects.requireNonNull(instance, "instance");
      b(instance.b());
      return this;
    }

    /**
     * Initializes the value for the {@link SillySub2#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSillySub2 ImmutableSillySub2}.
     * @return An immutable instance of SillySub2
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSillySub2 build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSillySub2(b);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build SillySub2, some of required attributes are not set " + attributes;
    }
  }
}
