package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Sing1}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSing1.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableSing1.of()}.
 */
@Generated(from = "Sing1", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableSing1 implements Sing1 {
  private final ImmutableList<Integer> list;

  private ImmutableSing1() {
    this.list = ImmutableList.of();
  }

  private ImmutableSing1(ImmutableList<Integer> list) {
    this.list = list;
  }

  /**
   * @return The value of the {@code list} attribute
   */
  @Override
  public ImmutableList<Integer> list() {
    return list;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Sing1#list() list}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSing1 withList(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return validate(new ImmutableSing1(newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Sing1#list() list}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of list elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSing1 withList(Iterable<Integer> elements) {
    if (this.list == elements) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableSing1(newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSing1} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSing1
        && equalTo(0, (ImmutableSing1) another);
  }

  private boolean equalTo(int synthetic, ImmutableSing1 another) {
    return list.equals(another.list);
  }

  /**
   * Computes a hash code from attributes: {@code list}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + list.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Sing1} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Sing1")
        .omitNullValues()
        .add("list", list)
        .toString();
  }

  private static final ImmutableSing1 INSTANCE = validate(new ImmutableSing1());

  /**
   * Returns the default immutable singleton value of {@code Sing1}
   * @return An immutable instance of Sing1
   */
  public static ImmutableSing1 of() {
    return INSTANCE;
  }

  private static ImmutableSing1 validate(ImmutableSing1 instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link Sing1} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Sing1 instance
   */
  public static ImmutableSing1 copyOf(Sing1 instance) {
    if (instance instanceof ImmutableSing1) {
      return (ImmutableSing1) instance;
    }
    return ImmutableSing1.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSing1 ImmutableSing1}.
   * <pre>
   * ImmutableSing1.builder()
   *    .addList|addAllList(int) // {@link Sing1#list() list} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSing1 builder
   */
  public static ImmutableSing1.Builder builder() {
    return new ImmutableSing1.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSing1 ImmutableSing1}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Sing1", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<Integer> list = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Sing1} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Sing1 instance) {
      Objects.requireNonNull(instance, "instance");
      addAllList(instance.list());
      return this;
    }

    /**
     * Adds one element to {@link Sing1#list() list} list.
     * @param element A list element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addList(int element) {
      this.list.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Sing1#list() list} list.
     * @param elements An array of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addList(int... elements) {
      this.list.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Sing1#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder list(Iterable<Integer> elements) {
      this.list = ImmutableList.builder();
      return addAllList(elements);
    }

    /**
     * Adds elements to {@link Sing1#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllList(Iterable<Integer> elements) {
      this.list.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSing1 ImmutableSing1}.
     * @return An immutable instance of Sing1
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSing1 build() {
      return ImmutableSing1.validate(new ImmutableSing1(list.build()));
    }
  }
}
