package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UnderwriteObjectMethods.Underwrite}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUnderwrite.builder()}.
 */
@Generated(from = "UnderwriteObjectMethods.Underwrite", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUnderwrite extends UnderwriteObjectMethods.Underwrite {
  private final int value;

  private ImmutableUnderwrite(int value) {
    this.value = value;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public int value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UnderwriteObjectMethods.Underwrite#value() value} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUnderwrite withValue(int value) {
    if (this.value == value) return this;
    return new ImmutableUnderwrite(value);
  }

  /**
   * Creates an immutable copy of a {@link UnderwriteObjectMethods.Underwrite} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Underwrite instance
   */
  public static ImmutableUnderwrite copyOf(UnderwriteObjectMethods.Underwrite instance) {
    if (instance instanceof ImmutableUnderwrite) {
      return (ImmutableUnderwrite) instance;
    }
    return ImmutableUnderwrite.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUnderwrite ImmutableUnderwrite}.
   * <pre>
   * ImmutableUnderwrite.builder()
   *    .value(int) // required {@link UnderwriteObjectMethods.Underwrite#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableUnderwrite builder
   */
  public static ImmutableUnderwrite.Builder builder() {
    return new ImmutableUnderwrite.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUnderwrite ImmutableUnderwrite}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UnderwriteObjectMethods.Underwrite", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private int value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Underwrite} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UnderwriteObjectMethods.Underwrite instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link UnderwriteObjectMethods.Underwrite#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(int value) {
      this.value = value;
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUnderwrite ImmutableUnderwrite}.
     * @return An immutable instance of Underwrite
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUnderwrite build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUnderwrite(value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build Underwrite, some of required attributes are not set " + attributes;
    }
  }
}
