package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UnrelatedGenericMethods}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUnrelatedGenericMethods.builder()}.
 */
@Generated(from = "UnrelatedGenericMethods", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUnrelatedGenericMethods extends UnrelatedGenericMethods {
  private final String a;

  private ImmutableUnrelatedGenericMethods(String a) {
    this.a = a;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public String a() {
    return a;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UnrelatedGenericMethods#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUnrelatedGenericMethods withA(String value) {
    String newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableUnrelatedGenericMethods(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUnrelatedGenericMethods} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUnrelatedGenericMethods
        && equalTo(0, (ImmutableUnrelatedGenericMethods) another);
  }

  private boolean equalTo(int synthetic, ImmutableUnrelatedGenericMethods another) {
    return a.equals(another.a);
  }

  /**
   * Computes a hash code from attributes: {@code a}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UnrelatedGenericMethods} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UnrelatedGenericMethods")
        .omitNullValues()
        .add("a", a)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link UnrelatedGenericMethods} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UnrelatedGenericMethods instance
   */
  public static ImmutableUnrelatedGenericMethods copyOf(UnrelatedGenericMethods instance) {
    if (instance instanceof ImmutableUnrelatedGenericMethods) {
      return (ImmutableUnrelatedGenericMethods) instance;
    }
    return ImmutableUnrelatedGenericMethods.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUnrelatedGenericMethods ImmutableUnrelatedGenericMethods}.
   * <pre>
   * ImmutableUnrelatedGenericMethods.builder()
   *    .a(String) // required {@link UnrelatedGenericMethods#a() a}
   *    .build();
   * </pre>
   * @return A new ImmutableUnrelatedGenericMethods builder
   */
  public static ImmutableUnrelatedGenericMethods.Builder builder() {
    return new ImmutableUnrelatedGenericMethods.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUnrelatedGenericMethods ImmutableUnrelatedGenericMethods}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UnrelatedGenericMethods", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String a;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnrelatedGenericMethods} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UnrelatedGenericMethods instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      return this;
    }

    /**
     * Initializes the value for the {@link UnrelatedGenericMethods#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(String a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUnrelatedGenericMethods ImmutableUnrelatedGenericMethods}.
     * @return An immutable instance of UnrelatedGenericMethods
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUnrelatedGenericMethods build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUnrelatedGenericMethods(a);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build UnrelatedGenericMethods, some of required attributes are not set " + attributes;
    }
  }
}
