package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UseImmutableCollections}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUseImmutableCollections.builder()}.
 */
@Generated(from = "UseImmutableCollections", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUseImmutableCollections implements UseImmutableCollections {
  private final ImmutableList<String> list;
  private final ImmutableSet<Integer> set;
  private final ImmutableSet<RetentionPolicy> enumSet;
  private final ImmutableSortedSet<RetentionPolicy> sortedSet;
  private final ImmutableMultiset<String> multiset;
  private final ImmutableMap<String, Integer> map;
  private final ImmutableMap<RetentionPolicy, Integer> enumMap;
  private final ImmutableSortedMap<RetentionPolicy, Integer> sortedMap;
  private final ImmutableMultimap<String, Integer> multimap;
  private final ImmutableSetMultimap<String, Integer> setMultimap;
  private final ImmutableListMultimap<String, Integer> listMultimap;

  private ImmutableUseImmutableCollections(
      ImmutableList<String> list,
      ImmutableSet<Integer> set,
      ImmutableSet<RetentionPolicy> enumSet,
      ImmutableSortedSet<RetentionPolicy> sortedSet,
      ImmutableMultiset<String> multiset,
      ImmutableMap<String, Integer> map,
      ImmutableMap<RetentionPolicy, Integer> enumMap,
      ImmutableSortedMap<RetentionPolicy, Integer> sortedMap,
      ImmutableMultimap<String, Integer> multimap,
      ImmutableSetMultimap<String, Integer> setMultimap,
      ImmutableListMultimap<String, Integer> listMultimap) {
    this.list = list;
    this.set = set;
    this.enumSet = enumSet;
    this.sortedSet = sortedSet;
    this.multiset = multiset;
    this.map = map;
    this.enumMap = enumMap;
    this.sortedMap = sortedMap;
    this.multimap = multimap;
    this.setMultimap = setMultimap;
    this.listMultimap = listMultimap;
  }

  /**
   * @return The value of the {@code list} attribute
   */
  @Override
  public ImmutableList<String> list() {
    return list;
  }

  /**
   * @return The value of the {@code set} attribute
   */
  @Override
  public ImmutableSet<Integer> set() {
    return set;
  }

  /**
   * @return The value of the {@code enumSet} attribute
   */
  @Override
  public ImmutableSet<RetentionPolicy> enumSet() {
    return enumSet;
  }

  /**
   * @return The value of the {@code sortedSet} attribute
   */
  @Override
  public ImmutableSortedSet<RetentionPolicy> sortedSet() {
    return sortedSet;
  }

  /**
   * @return The value of the {@code multiset} attribute
   */
  @Override
  public ImmutableMultiset<String> multiset() {
    return multiset;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @Override
  public ImmutableMap<String, Integer> map() {
    return map;
  }

  /**
   * @return The value of the {@code enumMap} attribute
   */
  @Override
  public ImmutableMap<RetentionPolicy, Integer> enumMap() {
    return enumMap;
  }

  /**
   * @return The value of the {@code sortedMap} attribute
   */
  @Override
  public ImmutableSortedMap<RetentionPolicy, Integer> sortedMap() {
    return sortedMap;
  }

  /**
   * @return The value of the {@code multimap} attribute
   */
  @Override
  public ImmutableMultimap<String, Integer> multimap() {
    return multimap;
  }

  /**
   * @return The value of the {@code setMultimap} attribute
   */
  @Override
  public ImmutableSetMultimap<String, Integer> setMultimap() {
    return setMultimap;
  }

  /**
   * @return The value of the {@code listMultimap} attribute
   */
  @Override
  public ImmutableListMultimap<String, Integer> listMultimap() {
    return listMultimap;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UseImmutableCollections#list() list}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withList(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUseImmutableCollections(
        newValue,
        this.set,
        this.enumSet,
        this.sortedSet,
        this.multiset,
        this.map,
        this.enumMap,
        this.sortedMap,
        this.multimap,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UseImmutableCollections#list() list}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of list elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withList(Iterable<String> elements) {
    if (this.list == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUseImmutableCollections(
        newValue,
        this.set,
        this.enumSet,
        this.sortedSet,
        this.multiset,
        this.map,
        this.enumMap,
        this.sortedMap,
        this.multimap,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UseImmutableCollections#set() set}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withSet(int... elements) {
    ImmutableSet<Integer> newValue = ImmutableSet.copyOf(Ints.asList(elements));
    return new ImmutableUseImmutableCollections(
        this.list,
        newValue,
        this.enumSet,
        this.sortedSet,
        this.multiset,
        this.map,
        this.enumMap,
        this.sortedMap,
        this.multimap,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UseImmutableCollections#set() set}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of set elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withSet(Iterable<Integer> elements) {
    if (this.set == elements) return this;
    ImmutableSet<Integer> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableUseImmutableCollections(
        this.list,
        newValue,
        this.enumSet,
        this.sortedSet,
        this.multiset,
        this.map,
        this.enumMap,
        this.sortedMap,
        this.multimap,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UseImmutableCollections#enumSet() enumSet}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withEnumSet(RetentionPolicy... elements) {
    ImmutableSet<RetentionPolicy> newValue = Sets.immutableEnumSet(Arrays.asList(elements));
    return new ImmutableUseImmutableCollections(
        this.list,
        this.set,
        newValue,
        this.sortedSet,
        this.multiset,
        this.map,
        this.enumMap,
        this.sortedMap,
        this.multimap,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UseImmutableCollections#enumSet() enumSet}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of enumSet elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withEnumSet(Iterable<RetentionPolicy> elements) {
    if (this.enumSet == elements) return this;
    ImmutableSet<RetentionPolicy> newValue = Sets.immutableEnumSet(elements);
    return new ImmutableUseImmutableCollections(
        this.list,
        this.set,
        newValue,
        this.sortedSet,
        this.multiset,
        this.map,
        this.enumMap,
        this.sortedMap,
        this.multimap,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UseImmutableCollections#sortedSet() sortedSet}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withSortedSet(RetentionPolicy... elements) {
    ImmutableSortedSet<RetentionPolicy> newValue = ImmutableSortedSet.copyOf(
        Ordering.<RetentionPolicy>natural(),
        Arrays.asList(elements));
    return new ImmutableUseImmutableCollections(
        this.list,
        this.set,
        this.enumSet,
        newValue,
        this.multiset,
        this.map,
        this.enumMap,
        this.sortedMap,
        this.multimap,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UseImmutableCollections#sortedSet() sortedSet}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sortedSet elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withSortedSet(Iterable<? extends RetentionPolicy> elements) {
    if (this.sortedSet == elements) return this;
    ImmutableSortedSet<RetentionPolicy> newValue = ImmutableSortedSet.copyOf(
        Ordering.<RetentionPolicy>natural(),
        elements);
    return new ImmutableUseImmutableCollections(
        this.list,
        this.set,
        this.enumSet,
        newValue,
        this.multiset,
        this.map,
        this.enumMap,
        this.sortedMap,
        this.multimap,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UseImmutableCollections#multiset() multiset}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withMultiset(String... elements) {
    ImmutableMultiset<String> newValue = ImmutableMultiset.copyOf(elements);
    return new ImmutableUseImmutableCollections(
        this.list,
        this.set,
        this.enumSet,
        this.sortedSet,
        newValue,
        this.map,
        this.enumMap,
        this.sortedMap,
        this.multimap,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UseImmutableCollections#multiset() multiset}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of multiset elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withMultiset(Iterable<String> elements) {
    if (this.multiset == elements) return this;
    ImmutableMultiset<String> newValue = ImmutableMultiset.copyOf(elements);
    return new ImmutableUseImmutableCollections(
        this.list,
        this.set,
        this.enumSet,
        this.sortedSet,
        newValue,
        this.map,
        this.enumMap,
        this.sortedMap,
        this.multimap,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object by replacing the {@link UseImmutableCollections#map() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withMap(Map<String, ? extends Integer> entries) {
    if (this.map == entries) return this;
    ImmutableMap<String, Integer> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableUseImmutableCollections(
        this.list,
        this.set,
        this.enumSet,
        this.sortedSet,
        this.multiset,
        newValue,
        this.enumMap,
        this.sortedMap,
        this.multimap,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object by replacing the {@link UseImmutableCollections#enumMap() enumMap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the enumMap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withEnumMap(Map<RetentionPolicy, ? extends Integer> entries) {
    if (this.enumMap == entries) return this;
    ImmutableMap<RetentionPolicy, Integer> newValue = Maps.immutableEnumMap(entries);
    return new ImmutableUseImmutableCollections(
        this.list,
        this.set,
        this.enumSet,
        this.sortedSet,
        this.multiset,
        this.map,
        newValue,
        this.sortedMap,
        this.multimap,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object by replacing the {@link UseImmutableCollections#sortedMap() sortedMap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the sortedMap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withSortedMap(Map<? extends RetentionPolicy, ? extends Integer> entries) {
    if (this.sortedMap == entries) return this;
    ImmutableSortedMap<RetentionPolicy, Integer> newValue = ImmutableSortedMap.copyOf(entries,
        Ordering.<RetentionPolicy>natural().reverse()
    );
    return new ImmutableUseImmutableCollections(
        this.list,
        this.set,
        this.enumSet,
        this.sortedSet,
        this.multiset,
        this.map,
        this.enumMap,
        newValue,
        this.multimap,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object by replacing the {@link UseImmutableCollections#multimap() multimap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the multimap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withMultimap(Multimap<String, ? extends Integer> entries) {
    if (this.multimap == entries) return this;
    ImmutableMultimap<String, Integer> newValue = ImmutableMultimap.copyOf(entries);
    return new ImmutableUseImmutableCollections(
        this.list,
        this.set,
        this.enumSet,
        this.sortedSet,
        this.multiset,
        this.map,
        this.enumMap,
        this.sortedMap,
        newValue,
        this.setMultimap,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object by replacing the {@link UseImmutableCollections#setMultimap() setMultimap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the setMultimap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withSetMultimap(Multimap<String, ? extends Integer> entries) {
    if (this.setMultimap == entries) return this;
    ImmutableSetMultimap<String, Integer> newValue = ImmutableSetMultimap.copyOf(entries);
    return new ImmutableUseImmutableCollections(
        this.list,
        this.set,
        this.enumSet,
        this.sortedSet,
        this.multiset,
        this.map,
        this.enumMap,
        this.sortedMap,
        this.multimap,
        newValue,
        this.listMultimap);
  }

  /**
   * Copy the current immutable object by replacing the {@link UseImmutableCollections#listMultimap() listMultimap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the listMultimap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUseImmutableCollections withListMultimap(Multimap<String, ? extends Integer> entries) {
    if (this.listMultimap == entries) return this;
    ImmutableListMultimap<String, Integer> newValue = ImmutableListMultimap.copyOf(entries);
    return new ImmutableUseImmutableCollections(
        this.list,
        this.set,
        this.enumSet,
        this.sortedSet,
        this.multiset,
        this.map,
        this.enumMap,
        this.sortedMap,
        this.multimap,
        this.setMultimap,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUseImmutableCollections} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUseImmutableCollections
        && equalTo(0, (ImmutableUseImmutableCollections) another);
  }

  private boolean equalTo(int synthetic, ImmutableUseImmutableCollections another) {
    return list.equals(another.list)
        && set.equals(another.set)
        && enumSet.equals(another.enumSet)
        && sortedSet.equals(another.sortedSet)
        && multiset.equals(another.multiset)
        && map.equals(another.map)
        && enumMap.equals(another.enumMap)
        && sortedMap.equals(another.sortedMap)
        && multimap.equals(another.multimap)
        && setMultimap.equals(another.setMultimap)
        && listMultimap.equals(another.listMultimap);
  }

  /**
   * Computes a hash code from attributes: {@code list}, {@code set}, {@code enumSet}, {@code sortedSet}, {@code multiset}, {@code map}, {@code enumMap}, {@code sortedMap}, {@code multimap}, {@code setMultimap}, {@code listMultimap}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + list.hashCode();
    h += (h << 5) + set.hashCode();
    h += (h << 5) + enumSet.hashCode();
    h += (h << 5) + sortedSet.hashCode();
    h += (h << 5) + multiset.hashCode();
    h += (h << 5) + map.hashCode();
    h += (h << 5) + enumMap.hashCode();
    h += (h << 5) + sortedMap.hashCode();
    h += (h << 5) + multimap.hashCode();
    h += (h << 5) + setMultimap.hashCode();
    h += (h << 5) + listMultimap.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UseImmutableCollections} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UseImmutableCollections")
        .omitNullValues()
        .add("list", list)
        .add("set", set)
        .add("enumSet", enumSet)
        .add("sortedSet", sortedSet)
        .add("multiset", multiset)
        .add("map", map)
        .add("enumMap", enumMap)
        .add("sortedMap", sortedMap)
        .add("multimap", multimap)
        .add("setMultimap", setMultimap)
        .add("listMultimap", listMultimap)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link UseImmutableCollections} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UseImmutableCollections instance
   */
  public static ImmutableUseImmutableCollections copyOf(UseImmutableCollections instance) {
    if (instance instanceof ImmutableUseImmutableCollections) {
      return (ImmutableUseImmutableCollections) instance;
    }
    return ImmutableUseImmutableCollections.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUseImmutableCollections ImmutableUseImmutableCollections}.
   * <pre>
   * ImmutableUseImmutableCollections.builder()
   *    .addList|addAllList(String) // {@link UseImmutableCollections#list() list} elements
   *    .addSet|addAllSet(int) // {@link UseImmutableCollections#set() set} elements
   *    .addEnumSet|addAllEnumSet(annotation.RetentionPolicy) // {@link UseImmutableCollections#enumSet() enumSet} elements
   *    .addSortedSet|addAllSortedSet(annotation.RetentionPolicy) // {@link UseImmutableCollections#sortedSet() sortedSet} elements
   *    .addMultiset|addAllMultiset(String) // {@link UseImmutableCollections#multiset() multiset} elements
   *    .putMap|putAllMap(String =&gt; int) // {@link UseImmutableCollections#map() map} mappings
   *    .putEnumMap|putAllEnumMap(annotation.RetentionPolicy =&gt; int) // {@link UseImmutableCollections#enumMap() enumMap} mappings
   *    .putSortedMap|putAllSortedMap(annotation.RetentionPolicy =&gt; int) // {@link UseImmutableCollections#sortedMap() sortedMap} mappings
   *    .putMultimap|putAllMultimap(String =&gt; int) // {@link UseImmutableCollections#multimap() multimap} mappings
   *    .putSetMultimap|putAllSetMultimap(String =&gt; int) // {@link UseImmutableCollections#setMultimap() setMultimap} mappings
   *    .putListMultimap|putAllListMultimap(String =&gt; int) // {@link UseImmutableCollections#listMultimap() listMultimap} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableUseImmutableCollections builder
   */
  public static ImmutableUseImmutableCollections.Builder builder() {
    return new ImmutableUseImmutableCollections.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUseImmutableCollections ImmutableUseImmutableCollections}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UseImmutableCollections", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<String> list = ImmutableList.builder();
    private ImmutableSet.Builder<Integer> set = ImmutableSet.builder();
    private ImmutableSet.Builder<RetentionPolicy> enumSet = ImmutableSet.builder();
    private ImmutableSortedSet.Builder<RetentionPolicy> sortedSet = ImmutableSortedSet.naturalOrder();
    private ImmutableMultiset.Builder<String> multiset = ImmutableMultiset.builder();
    private ImmutableMap.Builder<String, Integer> map = ImmutableMap.builder();
    private ImmutableMap.Builder<RetentionPolicy, Integer> enumMap = ImmutableMap.builder();
    private ImmutableSortedMap.Builder<RetentionPolicy, Integer> sortedMap = ImmutableSortedMap.reverseOrder();
    private ImmutableMultimap.Builder<String, Integer> multimap = ImmutableMultimap.builder();
    private ImmutableSetMultimap.Builder<String, Integer> setMultimap = ImmutableSetMultimap.builder();
    private ImmutableListMultimap.Builder<String, Integer> listMultimap = ImmutableListMultimap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UseImmutableCollections} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UseImmutableCollections instance) {
      Objects.requireNonNull(instance, "instance");
      addAllList(instance.list());
      addAllSet(instance.set());
      addAllEnumSet(instance.enumSet());
      addAllSortedSet(instance.sortedSet());
      addAllMultiset(instance.multiset());
      putAllMap(instance.map());
      putAllEnumMap(instance.enumMap());
      putAllSortedMap(instance.sortedMap());
      putAllMultimap(instance.multimap());
      putAllSetMultimap(instance.setMultimap());
      putAllListMultimap(instance.listMultimap());
      return this;
    }

    /**
     * Adds one element to {@link UseImmutableCollections#list() list} list.
     * @param element A list element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addList(String element) {
      this.list.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UseImmutableCollections#list() list} list.
     * @param elements An array of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addList(String... elements) {
      this.list.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UseImmutableCollections#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder list(Iterable<String> elements) {
      this.list = ImmutableList.builder();
      return addAllList(elements);
    }

    /**
     * Adds elements to {@link UseImmutableCollections#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllList(Iterable<String> elements) {
      this.list.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link UseImmutableCollections#set() set} set.
     * @param element A set element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSet(int element) {
      this.set.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UseImmutableCollections#set() set} set.
     * @param elements An array of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSet(int... elements) {
      this.set.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UseImmutableCollections#set() set} set.
     * @param elements An iterable of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder set(Iterable<Integer> elements) {
      this.set = ImmutableSet.builder();
      return addAllSet(elements);
    }

    /**
     * Adds elements to {@link UseImmutableCollections#set() set} set.
     * @param elements An iterable of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSet(Iterable<Integer> elements) {
      this.set.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link UseImmutableCollections#enumSet() enumSet} set.
     * @param element A enumSet element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEnumSet(RetentionPolicy element) {
      this.enumSet.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UseImmutableCollections#enumSet() enumSet} set.
     * @param elements An array of enumSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEnumSet(RetentionPolicy... elements) {
      this.enumSet.addAll(Arrays.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UseImmutableCollections#enumSet() enumSet} set.
     * @param elements An iterable of enumSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder enumSet(Iterable<RetentionPolicy> elements) {
      this.enumSet = ImmutableSet.builder();
      return addAllEnumSet(elements);
    }

    /**
     * Adds elements to {@link UseImmutableCollections#enumSet() enumSet} set.
     * @param elements An iterable of enumSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEnumSet(Iterable<RetentionPolicy> elements) {
      this.enumSet.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link UseImmutableCollections#sortedSet() sortedSet} sortedSet.
     * @param element A sortedSet element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSortedSet(RetentionPolicy element) {
      this.sortedSet.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UseImmutableCollections#sortedSet() sortedSet} sortedSet.
     * @param elements An array of sortedSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSortedSet(RetentionPolicy... elements) {
      this.sortedSet.addAll(Arrays.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UseImmutableCollections#sortedSet() sortedSet} sortedSet.
     * @param elements An iterable of sortedSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sortedSet(Iterable<? extends RetentionPolicy> elements) {
      this.sortedSet = ImmutableSortedSet.naturalOrder();
      return addAllSortedSet(elements);
    }

    /**
     * Adds elements to {@link UseImmutableCollections#sortedSet() sortedSet} sortedSet.
     * @param elements An iterable of sortedSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSortedSet(Iterable<? extends RetentionPolicy> elements) {
      this.sortedSet.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link UseImmutableCollections#multiset() multiset} multiset.
     * @param element A multiset element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMultiset(String element) {
      this.multiset.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UseImmutableCollections#multiset() multiset} multiset.
     * @param elements An array of multiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMultiset(String... elements) {
      this.multiset.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UseImmutableCollections#multiset() multiset} multiset.
     * @param elements An iterable of multiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder multiset(Iterable<String> elements) {
      this.multiset = ImmutableMultiset.builder();
      return addAllMultiset(elements);
    }

    /**
     * Adds elements to {@link UseImmutableCollections#multiset() multiset} multiset.
     * @param elements An iterable of multiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMultiset(Iterable<String> elements) {
      this.multiset.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link UseImmutableCollections#map() map} map.
     * @param key The key in the map map
     * @param value The associated value in the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(String key, int value) {
      this.map.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UseImmutableCollections#map() map} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(Map.Entry<String, ? extends Integer> entry) {
      this.map.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UseImmutableCollections#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder map(Map<String, ? extends Integer> entries) {
      this.map = ImmutableMap.builder();
      return putAllMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UseImmutableCollections#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMap(Map<String, ? extends Integer> entries) {
      this.map.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link UseImmutableCollections#enumMap() enumMap} map.
     * @param key The key in the enumMap map
     * @param value The associated value in the enumMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putEnumMap(RetentionPolicy key, int value) {
      this.enumMap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UseImmutableCollections#enumMap() enumMap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putEnumMap(Map.Entry<RetentionPolicy, ? extends Integer> entry) {
      this.enumMap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UseImmutableCollections#enumMap() enumMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the enumMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder enumMap(Map<RetentionPolicy, ? extends Integer> entries) {
      this.enumMap = ImmutableMap.builder();
      return putAllEnumMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UseImmutableCollections#enumMap() enumMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the enumMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllEnumMap(Map<RetentionPolicy, ? extends Integer> entries) {
      this.enumMap.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link UseImmutableCollections#sortedMap() sortedMap} map.
     * @param key The key in the sortedMap map
     * @param value The associated value in the sortedMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putSortedMap(RetentionPolicy key, int value) {
      this.sortedMap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UseImmutableCollections#sortedMap() sortedMap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putSortedMap(Map.Entry<? extends RetentionPolicy, ? extends Integer> entry) {
      this.sortedMap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UseImmutableCollections#sortedMap() sortedMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the sortedMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sortedMap(Map<? extends RetentionPolicy, ? extends Integer> entries) {
      this.sortedMap = ImmutableSortedMap.reverseOrder();
      return putAllSortedMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UseImmutableCollections#sortedMap() sortedMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the sortedMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllSortedMap(Map<? extends RetentionPolicy, ? extends Integer> entries) {
      this.sortedMap.putAll(entries);
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link UseImmutableCollections#multimap() multimap} true. Nulls are not permitted
     * @param key The key for multimap
     * @param values The values for multimap
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMultimap(String key, int... values) {
      this.multimap.putAll(key, Ints.asList(values));
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link UseImmutableCollections#multimap() multimap} true. Nulls are not permitted
     * @param key The key for multimap
     * @param values The values for multimap
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMultimap(String key, Iterable<Integer> values) {
      this.multimap.putAll(key, values);
      return this;
    }

    /**
     * Put one entry to the {@link UseImmutableCollections#multimap() multimap} map.
     * @param key The key in the multimap map
     * @param value The associated value in the multimap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMultimap(String key, int value) {
      this.multimap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UseImmutableCollections#multimap() multimap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMultimap(Map.Entry<String, ? extends Integer> entry) {
      this.multimap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UseImmutableCollections#multimap() multimap} map. Nulls are not permitted
     * @param entries The entries that will be added to the multimap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder multimap(Multimap<String, ? extends Integer> entries) {
      this.multimap = ImmutableMultimap.builder();
      return putAllMultimap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UseImmutableCollections#multimap() multimap} map. Nulls are not permitted
     * @param entries The entries that will be added to the multimap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMultimap(Multimap<String, ? extends Integer> entries) {
      this.multimap.putAll(entries);
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link UseImmutableCollections#setMultimap() setMultimap} true. Nulls are not permitted
     * @param key The key for setMultimap
     * @param values The values for setMultimap
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putSetMultimap(String key, int... values) {
      this.setMultimap.putAll(key, Ints.asList(values));
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link UseImmutableCollections#setMultimap() setMultimap} true. Nulls are not permitted
     * @param key The key for setMultimap
     * @param values The values for setMultimap
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllSetMultimap(String key, Iterable<Integer> values) {
      this.setMultimap.putAll(key, values);
      return this;
    }

    /**
     * Put one entry to the {@link UseImmutableCollections#setMultimap() setMultimap} map.
     * @param key The key in the setMultimap map
     * @param value The associated value in the setMultimap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putSetMultimap(String key, int value) {
      this.setMultimap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UseImmutableCollections#setMultimap() setMultimap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putSetMultimap(Map.Entry<String, ? extends Integer> entry) {
      this.setMultimap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UseImmutableCollections#setMultimap() setMultimap} map. Nulls are not permitted
     * @param entries The entries that will be added to the setMultimap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder setMultimap(Multimap<String, ? extends Integer> entries) {
      this.setMultimap = ImmutableSetMultimap.builder();
      return putAllSetMultimap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UseImmutableCollections#setMultimap() setMultimap} map. Nulls are not permitted
     * @param entries The entries that will be added to the setMultimap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllSetMultimap(Multimap<String, ? extends Integer> entries) {
      this.setMultimap.putAll(entries);
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link UseImmutableCollections#listMultimap() listMultimap} true. Nulls are not permitted
     * @param key The key for listMultimap
     * @param values The values for listMultimap
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putListMultimap(String key, int... values) {
      this.listMultimap.putAll(key, Ints.asList(values));
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link UseImmutableCollections#listMultimap() listMultimap} true. Nulls are not permitted
     * @param key The key for listMultimap
     * @param values The values for listMultimap
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllListMultimap(String key, Iterable<Integer> values) {
      this.listMultimap.putAll(key, values);
      return this;
    }

    /**
     * Put one entry to the {@link UseImmutableCollections#listMultimap() listMultimap} map.
     * @param key The key in the listMultimap map
     * @param value The associated value in the listMultimap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putListMultimap(String key, int value) {
      this.listMultimap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UseImmutableCollections#listMultimap() listMultimap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putListMultimap(Map.Entry<String, ? extends Integer> entry) {
      this.listMultimap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UseImmutableCollections#listMultimap() listMultimap} map. Nulls are not permitted
     * @param entries The entries that will be added to the listMultimap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder listMultimap(Multimap<String, ? extends Integer> entries) {
      this.listMultimap = ImmutableListMultimap.builder();
      return putAllListMultimap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UseImmutableCollections#listMultimap() listMultimap} map. Nulls are not permitted
     * @param entries The entries that will be added to the listMultimap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllListMultimap(Multimap<String, ? extends Integer> entries) {
      this.listMultimap.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableUseImmutableCollections ImmutableUseImmutableCollections}.
     * @return An immutable instance of UseImmutableCollections
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUseImmutableCollections build() {
      return new ImmutableUseImmutableCollections(
          list.build(),
          set.build(),
          Sets.immutableEnumSet(enumSet.build()),
          sortedSet.build(),
          multiset.build(),
          map.build(),
          Maps.immutableEnumMap(enumMap.build()),
          sortedMap.build(),
          multimap.build(),
          setMultimap.build(),
          listMultimap.build());
    }
  }
}
