package org.immutables.fixture;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;
import org.immutables.mongo.types.Id;
import org.immutables.value.Generated;

/**
 * A {@code SillyEntitySecondRepository} provides type-safe access for storing and retrieving documents
 * from the MongoDB collection {@code "ent2"}.
 */
@Generated(from = "SillyEntitySecond", generator = "Repositories")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@ThreadSafe
public class SillyEntitySecondRepository extends Repositories.Repository<SillyEntitySecond> {
  private static final String DOCUMENT_COLLECTION_NAME = "ent2";

  private final Serialization serialization;
  private final Criteria anyCriteria;

  /**
   * Constructs a {@link SillyEntitySecond} repository using {@link RepositorySetup configuration}.
   * @param configuration The repository configuration
   */
  public SillyEntitySecondRepository(RepositorySetup configuration) {
    super(configuration, DOCUMENT_COLLECTION_NAME, SillyEntitySecond.class);
    this.serialization = new Serialization(codecRegistry(), fieldNamingStrategy());
    this.anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());
  }

  /**
   * Inserts a single document into the collection.
   * @param document The sillyEntitySecond to insert
   * @return A future representing the number of inserted documents (1) if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(SillyEntitySecond document) {
    return super.doInsert(ImmutableList.of(document));
  }

  /**
   * Insert documents into the collection.
   * @param documents The documents to insert
   * @return A future representing the number of inserted documents if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(Iterable<? extends SillyEntitySecond> documents) {
    return super.doInsert(ImmutableList.copyOf(documents));
  }

  /**
   * Finds all documents. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch all} or other operations.
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder findAll() {
    return find(criteria());
  }

  /**
   * Find documents by the criteria expressed as a JSON string. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch} or {@link Finder#fetchFirst() fetch} operations.
   * @param jsonCriteria A JSON string for native criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(String jsonCriteria) {
    return new Finder(this, Support.jsonQuery(jsonCriteria));
  }

  /**
   * Find documents by the {@link SillyEntitySecond#id() id} identity attribute. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchFirst() fetch} or {@link Finder#fetchAll() fetchAll} read operations.
   * You can also use {@link Finder#andModifyFirst() modify}, {@link Finder#andReplaceFirst(SillyEntitySecond) replace}
   * or {@link Finder#deleteFirst() delete} operations to update / delete the document.
   * @param id The exact {@code id} value
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder findById(Id id) {
    return find(criteria().id(id));
  }

  /**
   * Update or insert a document, matched by the identifier value of the 'id' attribute.
   * @param document The sillyEntitySecond to upsert
   * @return A future representing the of number of inserted documents (1) if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> upsert(SillyEntitySecond document) {
    Criteria byId = criteria().id(document.id());
    return super.doUpsert(byId.constraint, document);
  }

  /**
   * Find a document by the given {@link SillyEntitySecondRepository#criteria() criteria}. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch}  operations.
   * You can also use {@link Finder#andModifyFirst() modify} or {@link Finder#deleteFirst() delete}
   * operations to update / delete the document(s).
   * @param criteria The search criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(Criteria criteria) {
    return new Finder(this, criteria.constraint);
  }

  /**
   * The finder object used to proceed with find operations via the
   * {@link Finder#fetchAll()}, {@link Finder#fetchFirst()}, {@link Finder#andModifyFirst()}, or {@link Finder#deleteFirst()} methods.
   * Configure exclusion and sort ordering for results using the family of {@code exclude*()} and {@code orderBy*()} attribute-specific methods.
   * @see SillyEntitySecondRepository#find(Criteria)
   */
  @Generated(from = "SillyEntitySecond", generator = "Repositories")
  @NotThreadSafe
  public static final class Finder extends Repositories.FinderWithDelete<SillyEntitySecond, Finder> {
    private final Serialization serialization;

    private Finder(SillyEntitySecondRepository repository, Constraints.ConstraintHost criteria) {
      super(repository);
      this.criteria = criteria;
      this.serialization = repository.serialization;
    }

    /**
     * Order by {@link SillyEntitySecond#id() id} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillyEntitySecond#id() id} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderById() {
      ordering = ordering.equal(serialization.idName, false, 1);
      return this;
    }

    /**
     * Order by {@link SillyEntitySecond#id() id} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillyEntitySecond#id() id} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByIdDesceding() {
      ordering = ordering.equal(serialization.idName, false, -1);
      return this;
    }

    /**
     * Turn a find operation into an atomic {@link DBCollection#findAndModify(DBObject, DBObject, DBObject, boolean, DBObject, boolean, boolean) findAndModify}
     * operation. Use the family of {@code set*()}, {@code unset*()}, {@code add*()}, {@code remove*()}, {@code put*()}m and {@code init*()}
     * (and other attribute-specific) methods to describe the modification.
     * @return A modifier object to complete the {@code findAndModify} operation
     */
    @CheckReturnValue
    public Modifier andModifyFirst() {
      return new Modifier((SillyEntitySecondRepository) repository, criteria, ordering, exclusion);
    }

    /**
     * Used to replace in-place existing version of the document
     */
    @CheckReturnValue
    public Replacer andReplaceFirst(SillyEntitySecond document) {
      return new Replacer((SillyEntitySecondRepository) repository, document, criteria, ordering);
    }
  }

  /**
   * Update the set of {@code "ent2"} documents.
   * @param criteria The search criteria for update
   * @return An updater object that will be used to complete the update.
   */
  @CheckReturnValue
  public Updater update(Criteria criteria) {
    return new Updater(this, criteria);
  }

  /**
   * {@link #update(Criteria) Given} the criteria updater describes how to perform
   * update operations on sets of documents.
   */
  @Generated(from = "SillyEntitySecond", generator = "Repositories")
  @NotThreadSafe
  public static final class Updater extends Repositories.Updater<SillyEntitySecond> {
    private final Serialization serialization;

    private Updater(SillyEntitySecondRepository repository, Criteria criteria) {
      super(repository);
      this.criteria = criteria.constraint;
      this.serialization = repository.serialization;
    }

    /**
     * Specify a new value for the {@code id} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code id} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setId(Id value) {
      setFields = setFields.equal(serialization.idName, false, Support.writable(serialization.idEncoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code id} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code id} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initId(Id value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.idName, false, Support.writable(serialization.idEncoder, value));
      return this;
    }

  }

  @Generated(from = "SillyEntitySecond", generator = "Repositories")
  @NotThreadSafe
  public static final class Modifier extends Repositories.Modifier<SillyEntitySecond, Modifier> {
    private final Serialization serialization;

    private Modifier(
        SillyEntitySecondRepository repository,
        Constraints.ConstraintHost criteria,
        Constraints.Constraint ordering,
        Constraints.Constraint exclusion) {
      super(repository);
      this.serialization = repository.serialization;
      this.criteria = criteria;
      this.ordering = ordering;
      this.exclusion = exclusion;
    }

    /**
     * Specify a new value for the {@code id} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code id} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setId(Id value) {
      setFields = setFields.equal(serialization.idName, false, Support.writable(serialization.idEncoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code id} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code id} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initId(Id value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.idName, false, Support.writable(serialization.idEncoder, value));
      return this;
    }

  }

  @Generated(from = "SillyEntitySecond", generator = "Repositories")
  @NotThreadSafe
  public static final class Replacer extends Repositories.Replacer<SillyEntitySecond, Replacer> {
    protected Replacer(SillyEntitySecondRepository repository, SillyEntitySecond document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
      super(repository, document, criteria, ordering);
    }
  }

  /**
   * {@link DBCollection#createIndex(DBObject, DBObject) Ensure an index} on collection ent2 by one or
   * more attributes using the family of {@code with*()} attribute-specific methods.
   * While indexes will usually be maintained by special administration scripts, for simple cases it is convenient
   * to ensure an index on application startup.
   * @see Indexer#named(String)
   * @see Indexer#unique()
   * @return An indexer object to be completed with the {@link Indexer#ensure()} operation.
   */
  @CheckReturnValue
  public Indexer index() {
    return new Indexer(this);
  }

  /**
   * An indexer used to create an index on the {@code "ent2"} collection if it does not exist by one or more attributes.
   * @see DBCollection#createIndex(DBObject, DBObject)
   */
  @Generated(from = "SillyEntitySecond", generator = "Repositories")
  @NotThreadSafe
  public static final class Indexer extends Repositories.Indexer<SillyEntitySecond, Indexer> {
    private final Serialization serialization;

    private Indexer(SillyEntitySecondRepository repository) {
      super(repository);
      this.serialization = repository.serialization;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyEntitySecond#id() id}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withId() {
      fields = fields.equal(serialization.idName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillyEntitySecond#id() id}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withIdDesceding() {
      fields = fields.equal(serialization.idName, false, -1);
      return this;
    }
  }

  /**
   * Search criteria.
   * Returns an initial object to create criteria by invoking methods that describe attribute specific constraints.
   * @return An empty immutable criteria
   */
  public Criteria criteria() {
    return anyCriteria;
  }

  @Beta
  Bson toBson(Criteria criteria) {
    return Support.convertToBson(criteria.constraint);
  }

  /**
   * {@code SillyEntitySecondRepository.Criteria} is a SillyEntitySecond document search query.
   * Call methods on the criteria to add constraints for search queries.
   */
  @Generated(from = "SillyEntitySecond", generator = "Repositories")
  @Immutable
  @SuppressWarnings("unchecked")
  public static final class Criteria extends Repositories.Criteria {
    private final Constraints.Constraint constraint;
    private final Serialization serialization;

    Criteria(Serialization serialization, Constraints.Constraint constraint) {
      this.constraint = constraint;
      this.serialization = serialization;
    }

    public Criteria id(Id value) {
      return new Criteria(serialization, constraint.equal(serialization.idName, false, Support.writable(serialization.idEncoder, value)));
    }

    public Criteria idNot(Id value) {
      return new Criteria(serialization, constraint.equal(serialization.idName, true, Support.writable(serialization.idEncoder, value)));
    }

    public Criteria idIn(Iterable<Id> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Id value : values) {
        wrappedValues.add(Support.writable(serialization.idEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, false, wrappedValues));
    }

    public Criteria idIn(Id first, Id second, Id... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.idEncoder, first));
      values.add(Support.writable(serialization.idEncoder, second));
      for (Id value : rest) {
        values.add(Support.writable(serialization.idEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, false, values));
    }

    public Criteria idNotIn(Iterable<Id> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Id value : values) {
        wrappedValues.add(Support.writable(serialization.idEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, true, wrappedValues));
    }

    public Criteria idNotIn(Id first, Id second, Id... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.idEncoder, first));
      values.add(Support.writable(serialization.idEncoder, second));
      for (Id value : rest) {
        values.add(Support.writable(serialization.idEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, true, values));
    }

    @Override
    public Criteria or() {
      return new Criteria(serialization, constraint.disjunction());
    }

    public Criteria with(Criteria criteria) {
      return new Criteria(serialization, criteria.constraint.accept(constraint));
    }

    @Override
    public String toString() {
      return "SillyEntitySecondRepository.criteria(" + Support.stringify(constraint) + ")";
    }
  }

  @Generated(from = "SillyEntitySecond", generator = "Repositories")
  private static class Serialization {
    final Encoder<Id> idEncoder;
    final CodecRegistry registry;
    final String idName;

    Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {
      this.registry = registry;
      this.idEncoder = this.registry.get(Id.class);
      this.idName = "_id";
    }

    @Generated(from = "SillyEntitySecond", generator = "Repositories")
    static final class SillyEntitySecondNamingFields {
      public Id id;
    }

    private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {
      try {
        return fieldNamingStrategy.translateName(
            SillyEntitySecondNamingFields.class.getField(fieldName));
      } catch (NoSuchFieldException noSuchField) {
        throw new AssertionError(noSuchField);
      }
    }
  }
}
