package org.immutables.fixture.annotation;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Be}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBe.builder()}.
 */
@Generated(from = "Be", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableBe implements Be {
  private static final java.lang.Class<? extends Number>[] DEFAULT_VALUE_CL;

  static {
    try {
      DEFAULT_VALUE_CL =
          cast(Be.class.getDeclaredMethod("cl").getDefaultValue());
    } catch(Exception e) {
      throw new ExceptionInInitializerError(e);
    }
  }

  @SuppressWarnings("unchecked")
  private static <T> T cast(Object object) {
    return (T) object;
  }
  private final java.lang.Class<? extends Number>[] cl;

  private ImmutableBe(ImmutableBe.Builder builder) {
    this.cl = builder.cl != null
        ? builder.cl
        : DEFAULT_VALUE_CL;
  }

  private ImmutableBe(java.lang.Class<? extends Number>[] cl) {
    this.cl = cl;
  }

  /** {@inheritDoc} */
  @Override
  public Class<? extends Annotation> annotationType() {
    return Be.class;
  }

  /**
   * @return A cloned {@code cl} array
   */
  @Override
  public java.lang.Class<? extends Number>[] cl() {
    return cl.clone();
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Be#cl() cl}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for cl
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableBe withCl(java.lang.Class<? extends Number>... elements) {
    java.lang.Class<? extends Number>[] newValue = elements.clone();
    return new ImmutableBe(newValue);
  }

  /**
   * This instance is equal to any implementation of the {@link ImmutableBe} type with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Be
        && equalTo(0, (Be) another);
  }

  private boolean equalTo(int synthetic, Be another) {
    return Arrays.equals(cl, another.cl());
  }

  /**
   * Computes a hash code from attributes: {@code cl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 0;
    h += 127 * "cl".hashCode() ^ Arrays.hashCode(cl);
    return h;
  }

  /**
   * Prints the immutable value {@code Be} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("@Be")
        .omitNullValues()
        .add("cl", Arrays.toString(cl))
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Be} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Be instance
   */
  public static ImmutableBe copyOf(Be instance) {
    if (instance instanceof ImmutableBe) {
      return (ImmutableBe) instance;
    }
    return ImmutableBe.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBe ImmutableBe}.
   * <pre>
   * ImmutableBe.builder()
   *    .cl(Class&amp;lt;? extends Number&amp;gt;) // optional {@link Be#cl() cl}
   *    .build();
   * </pre>
   * @return A new ImmutableBe builder
   */
  public static ImmutableBe.Builder builder() {
    return new ImmutableBe.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBe ImmutableBe}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Be", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable java.lang.Class<? extends Number>[] cl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Be} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Be instance) {
      Objects.requireNonNull(instance, "instance");
      cl(instance.cl());
      return this;
    }

    /**
     * Initializes the value for the {@link Be#cl() cl} attribute.
     * <p><em>If not set, this attribute will have a default value as defined by {@link Be#cl() cl}.</em>
     * @param cl The elements for cl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder cl(java.lang.Class<? extends Number>... cl) {
      this.cl = cl.clone();
      return this;
    }

    /**
     * Builds a new {@link ImmutableBe ImmutableBe}.
     * @return An immutable instance of Be
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBe build() {
      return new ImmutableBe(this);
    }
  }
}
