package org.immutables.fixture.annotation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractDeeplyImmutable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeeplyImmutable.builder()}.
 */
@Generated(from = "AbstractDeeplyImmutable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@com.google.errorprone.annotations.Immutable
final class ImmutableDeeplyImmutable extends AbstractDeeplyImmutable {
  private final String a;
  private final String b;

  private ImmutableDeeplyImmutable(ImmutableDeeplyImmutable.Builder builder) {
    this.a = builder.a;
    this.b = builder.b != null
        ? builder.b
        : Objects.requireNonNull(super.getB(), "b");
  }

  private ImmutableDeeplyImmutable(String a, String b) {
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @JsonProperty("a")
  @Override
  public String getA() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @JsonProperty("b")
  @Override
  public String getB() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractDeeplyImmutable#getA() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeeplyImmutable withA(String value) {
    String newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableDeeplyImmutable(newValue, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractDeeplyImmutable#getB() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeeplyImmutable withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableDeeplyImmutable(this.a, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeeplyImmutable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeeplyImmutable
        && equalTo(0, (ImmutableDeeplyImmutable) another);
  }

  private boolean equalTo(int synthetic, ImmutableDeeplyImmutable another) {
    return a.equals(another.a)
        && b.equals(another.b);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeeplyImmutable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DeeplyImmutable")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractDeeplyImmutable", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractDeeplyImmutable {
    @Nullable String a;
    @Nullable String b;
    @JsonProperty("a")
    public void setA(String a) {
      this.a = a;
    }
    @JsonProperty("b")
    public void setB(String b) {
      this.b = b;
    }
    @Override
    public String getA() { throw new UnsupportedOperationException(); }
    @Override
    public String getB() { throw new UnsupportedOperationException(); }
    @Override
    public String getC() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDeeplyImmutable fromJson(Json json) {
    ImmutableDeeplyImmutable.Builder builder = ImmutableDeeplyImmutable.builder();
    if (json.a != null) {
      builder.a(json.a);
    }
    if (json.b != null) {
      builder.b(json.b);
    }
    return builder.build();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long C_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String c;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AbstractDeeplyImmutable#getC() c} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code c} attribute
   */
  @Override
  public String getC() {
    if ((lazyInitBitmap & C_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & C_LAZY_INIT_BIT) == 0) {
          this.c = Objects.requireNonNull(super.getC(), "c");
          lazyInitBitmap |= C_LAZY_INIT_BIT;
        }
      }
    }
    return c;
  }

  /**
   * Creates an immutable copy of a {@link AbstractDeeplyImmutable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeeplyImmutable instance
   */
  public static ImmutableDeeplyImmutable copyOf(AbstractDeeplyImmutable instance) {
    if (instance instanceof ImmutableDeeplyImmutable) {
      return (ImmutableDeeplyImmutable) instance;
    }
    return ImmutableDeeplyImmutable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeeplyImmutable ImmutableDeeplyImmutable}.
   * <pre>
   * ImmutableDeeplyImmutable.builder()
   *    .a(String) // required {@link AbstractDeeplyImmutable#getA() a}
   *    .b(String) // optional {@link AbstractDeeplyImmutable#getB() b}
   *    .build();
   * </pre>
   * @return A new ImmutableDeeplyImmutable builder
   */
  public static ImmutableDeeplyImmutable.Builder builder() {
    return new ImmutableDeeplyImmutable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeeplyImmutable ImmutableDeeplyImmutable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractDeeplyImmutable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String a;
    private @Nullable String b;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AbstractDeeplyImmutable} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractDeeplyImmutable instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.getA());
      b(instance.getB());
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractDeeplyImmutable#getA() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("a")
    public final Builder a(String a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractDeeplyImmutable#getB() b} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractDeeplyImmutable#getB() b}.</em>
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("b")
    public final Builder b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeeplyImmutable ImmutableDeeplyImmutable}.
     * @return An immutable instance of DeeplyImmutable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeeplyImmutable build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDeeplyImmutable(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build DeeplyImmutable, some of required attributes are not set " + attributes;
    }
  }
}
