package org.immutables.fixture.annotation;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HasDefault}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHasDefault.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableHasDefault.of()}.
 */
@Generated(from = "HasDefault", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableHasDefault implements HasDefault {
  private static final String DEFAULT_VALUE_OTHER_VALUE;

  static {
    try {
      DEFAULT_VALUE_OTHER_VALUE =
          cast(HasDefault.class.getDeclaredMethod("otherValue").getDefaultValue());
    } catch(Exception e) {
      throw new ExceptionInInitializerError(e);
    }
  }

  @SuppressWarnings("unchecked")
  private static <T> T cast(Object object) {
    return (T) object;
  }
  private final int value;
  private final String otherValue;

  private ImmutableHasDefault(int value) {
    this.value = value;
    this.otherValue = DEFAULT_VALUE_OTHER_VALUE;
  }

  private ImmutableHasDefault(ImmutableHasDefault.Builder builder) {
    this.value = builder.value;
    this.otherValue = builder.otherValue != null
        ? builder.otherValue
        : DEFAULT_VALUE_OTHER_VALUE;
  }

  private ImmutableHasDefault(int value, String otherValue) {
    this.value = value;
    this.otherValue = otherValue;
  }

  /** {@inheritDoc} */
  @Override
  public Class<? extends Annotation> annotationType() {
    return HasDefault.class;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public int value() {
    return value;
  }

  /**
   * @return The value of the {@code otherValue} attribute
   */
  @Override
  public String otherValue() {
    return otherValue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HasDefault#value() value} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHasDefault withValue(int value) {
    if (this.value == value) return this;
    return new ImmutableHasDefault(value, this.otherValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HasDefault#otherValue() otherValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for otherValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHasDefault withOtherValue(String value) {
    String newValue = Objects.requireNonNull(value, "otherValue");
    if (this.otherValue.equals(newValue)) return this;
    return new ImmutableHasDefault(this.value, newValue);
  }

  /**
   * This instance is equal to any implementation of the {@link ImmutableHasDefault} type with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof HasDefault
        && equalTo(0, (HasDefault) another);
  }

  private boolean equalTo(int synthetic, HasDefault another) {
    return value == another.value()
        && otherValue.equals(another.otherValue());
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code otherValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 0;
    h += 127 * "value".hashCode() ^ value;
    h += 127 * "otherValue".hashCode() ^ otherValue.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HasDefault} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("@HasDefault")
        .omitNullValues()
        .add("value", value)
        .add("otherValue", otherValue)
        .toString();
  }

  /**
   * Construct a new immutable {@code HasDefault} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable HasDefault instance
   */
  public static ImmutableHasDefault of(int value) {
    return new ImmutableHasDefault(value);
  }

  /**
   * Creates an immutable copy of a {@link HasDefault} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HasDefault instance
   */
  public static ImmutableHasDefault copyOf(HasDefault instance) {
    if (instance instanceof ImmutableHasDefault) {
      return (ImmutableHasDefault) instance;
    }
    return ImmutableHasDefault.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHasDefault ImmutableHasDefault}.
   * <pre>
   * ImmutableHasDefault.builder()
   *    .value(int) // required {@link HasDefault#value() value}
   *    .otherValue(String) // optional {@link HasDefault#otherValue() otherValue}
   *    .build();
   * </pre>
   * @return A new ImmutableHasDefault builder
   */
  public static ImmutableHasDefault.Builder builder() {
    return new ImmutableHasDefault.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHasDefault ImmutableHasDefault}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HasDefault", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private int value;
    private @Nullable String otherValue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HasDefault} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HasDefault instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.value());
      otherValue(instance.otherValue());
      return this;
    }

    /**
     * Initializes the value for the {@link HasDefault#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(int value) {
      this.value = value;
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link HasDefault#otherValue() otherValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link HasDefault#otherValue() otherValue}.</em>
     * @param otherValue The value for otherValue 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder otherValue(String otherValue) {
      this.otherValue = Objects.requireNonNull(otherValue, "otherValue");
      return this;
    }

    /**
     * Builds a new {@link ImmutableHasDefault ImmutableHasDefault}.
     * @return An immutable instance of HasDefault
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHasDefault build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHasDefault(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build HasDefault, some of required attributes are not set " + attributes;
    }
  }
}
