package org.immutables.fixture.annotation;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LazyhashAnnotation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLazyhashAnnotation.builder()}.
 */
@Generated(from = "LazyhashAnnotation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLazyhashAnnotation implements LazyhashAnnotation {
  @SuppressWarnings("Immutable")
  private transient int hashCode; // hashCode lazily computed

  private ImmutableLazyhashAnnotation(ImmutableLazyhashAnnotation.Builder builder) {
  }

  /** {@inheritDoc} */
  @Override
  public Class<? extends Annotation> annotationType() {
    return LazyhashAnnotation.class;
  }

  /**
   * This instance is equal to any implementation of the {@link ImmutableLazyhashAnnotation} type with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof LazyhashAnnotation
        && equalTo(0, (LazyhashAnnotation) another);
  }

  private boolean equalTo(int synthetic, LazyhashAnnotation another) {
    if (another instanceof ImmutableLazyhashAnnotation) {
      final int anotherHashCode = ((ImmutableLazyhashAnnotation) another).hashCode;
      if (hashCode != 0 && anotherHashCode != 0 && hashCode != anotherHashCode) return false;
    }
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1420574633;
  }

  /**
   * Prints the immutable value {@code LazyhashAnnotation}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "@LazyhashAnnotation";
  }

  /**
   * Creates an immutable copy of a {@link LazyhashAnnotation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LazyhashAnnotation instance
   */
  public static ImmutableLazyhashAnnotation copyOf(LazyhashAnnotation instance) {
    if (instance instanceof ImmutableLazyhashAnnotation) {
      return (ImmutableLazyhashAnnotation) instance;
    }
    return ImmutableLazyhashAnnotation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLazyhashAnnotation ImmutableLazyhashAnnotation}.
   * <pre>
   * ImmutableLazyhashAnnotation.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableLazyhashAnnotation builder
   */
  public static ImmutableLazyhashAnnotation.Builder builder() {
    return new ImmutableLazyhashAnnotation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLazyhashAnnotation ImmutableLazyhashAnnotation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LazyhashAnnotation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LazyhashAnnotation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(LazyhashAnnotation instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableLazyhashAnnotation ImmutableLazyhashAnnotation}.
     * @return An immutable instance of LazyhashAnnotation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLazyhashAnnotation build() {
      return new ImmutableLazyhashAnnotation(this);
    }
  }
}
