package org.immutables.fixture.annotation;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LazyhashAnnotationEmpty}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLazyhashAnnotationEmpty.builder()}.
 */
@Generated(from = "LazyhashAnnotationEmpty", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableLazyhashAnnotationEmpty
    implements LazyhashAnnotationEmpty {
  @SuppressWarnings("Immutable")
  private transient int hashCode; // hashCode lazily computed

  private ImmutableLazyhashAnnotationEmpty(ImmutableLazyhashAnnotationEmpty.Builder builder) {
  }

  /** {@inheritDoc} */
  @Override
  public Class<? extends Annotation> annotationType() {
    return LazyhashAnnotationEmpty.class;
  }

  /**
   * This instance is equal to any implementation of the {@link ImmutableLazyhashAnnotationEmpty} type with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof LazyhashAnnotationEmpty
        && equalTo(0, (LazyhashAnnotationEmpty) another);
  }

  private boolean equalTo(int synthetic, LazyhashAnnotationEmpty another) {
    if (another instanceof ImmutableLazyhashAnnotationEmpty) {
      final int anotherHashCode = ((ImmutableLazyhashAnnotationEmpty) another).hashCode;
      if (hashCode != 0 && anotherHashCode != 0 && hashCode != anotherHashCode) return false;
    }
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 1989359636;
  }

  /**
   * Prints the immutable value {@code LazyhashAnnotationEmpty}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "@LazyhashAnnotationEmpty";
  }

  /**
   * Creates an immutable copy of a {@link LazyhashAnnotationEmpty} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LazyhashAnnotationEmpty instance
   */
  public static ImmutableLazyhashAnnotationEmpty copyOf(LazyhashAnnotationEmpty instance) {
    if (instance instanceof ImmutableLazyhashAnnotationEmpty) {
      return (ImmutableLazyhashAnnotationEmpty) instance;
    }
    return ImmutableLazyhashAnnotationEmpty.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLazyhashAnnotationEmpty ImmutableLazyhashAnnotationEmpty}.
   * <pre>
   * ImmutableLazyhashAnnotationEmpty.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableLazyhashAnnotationEmpty builder
   */
  public static ImmutableLazyhashAnnotationEmpty.Builder builder() {
    return new ImmutableLazyhashAnnotationEmpty.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLazyhashAnnotationEmpty ImmutableLazyhashAnnotationEmpty}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LazyhashAnnotationEmpty", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LazyhashAnnotationEmpty} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(LazyhashAnnotationEmpty instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableLazyhashAnnotationEmpty ImmutableLazyhashAnnotationEmpty}.
     * @return An immutable instance of LazyhashAnnotationEmpty
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLazyhashAnnotationEmpty build() {
      return new ImmutableLazyhashAnnotationEmpty(this);
    }
  }
}
