package org.immutables.fixture.annotation;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PrehashAnnotation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePrehashAnnotation.builder()}.
 */
@Generated(from = "PrehashAnnotation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePrehashAnnotation implements PrehashAnnotation {

  private ImmutablePrehashAnnotation(ImmutablePrehashAnnotation.Builder builder) {
  }

  /** {@inheritDoc} */
  @Override
  public Class<? extends Annotation> annotationType() {
    return PrehashAnnotation.class;
  }

  /**
   * This instance is equal to any implementation of the {@link ImmutablePrehashAnnotation} type with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof PrehashAnnotation
        && equalTo(0, (PrehashAnnotation) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, PrehashAnnotation another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 1034188440;
  }

  /**
   * Prints the immutable value {@code PrehashAnnotation}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "@PrehashAnnotation";
  }

  /**
   * Creates an immutable copy of a {@link PrehashAnnotation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PrehashAnnotation instance
   */
  public static ImmutablePrehashAnnotation copyOf(PrehashAnnotation instance) {
    if (instance instanceof ImmutablePrehashAnnotation) {
      return (ImmutablePrehashAnnotation) instance;
    }
    return ImmutablePrehashAnnotation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePrehashAnnotation ImmutablePrehashAnnotation}.
   * <pre>
   * ImmutablePrehashAnnotation.builder()
   *    .build();
   * </pre>
   * @return A new ImmutablePrehashAnnotation builder
   */
  public static ImmutablePrehashAnnotation.Builder builder() {
    return new ImmutablePrehashAnnotation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePrehashAnnotation ImmutablePrehashAnnotation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PrehashAnnotation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PrehashAnnotation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PrehashAnnotation instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutablePrehashAnnotation ImmutablePrehashAnnotation}.
     * @return An immutable instance of PrehashAnnotation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePrehashAnnotation build() {
      return new ImmutablePrehashAnnotation(this);
    }
  }
}
